/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.phase;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.phase.Element;
import io.vertx.up.uca.job.plugin.JobOutcome;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

class OutPut {
    private static final Annal LOGGER = Annal.get(OutPut.class);
    private final transient Vertx vertx;
    private final transient Refer assist = new Refer();

    OutPut(Vertx vertx) {
        this.vertx = vertx;
    }

    OutPut bind(Refer assist) {
        if (Objects.nonNull(assist)) {
            this.assist.add(assist.get());
        }
        return this;
    }

    Future<Envelop> outcomeAsync(Envelop envelop, Mission mission) {
        if (envelop.valid()) {
            JobOutcome outcome = Element.outcome(mission);
            if (Objects.isNull(outcome)) {
                Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 4. Output without `JobOutcome`", new Object[]{mission.getCode()}));
                return Future.succeededFuture((Object)envelop);
            }
            LOGGER.info("[ Job ] {0} selected: {1}", new Object[]{"JobOutcome", outcome.getClass().getName()});
            Ut.contract((Object)outcome, Vertx.class, (Object)this.vertx);
            Ut.contract((Object)outcome, Mission.class, (Object)mission);
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 4. Output with `JobOutcome` = {1}", new Object[]{mission.getCode(), outcome.getClass().getName()}));
            return outcome.afterAsync(envelop);
        }
        Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] Terminal with error: {1}", new Object[]{mission.getCode(), ((Object)((Object)envelop.error())).getClass().getName()}));
        WebException error = envelop.error();
        error.printStackTrace();
        return Ux.future(envelop);
    }

    Future<Envelop> outputAsync(Envelop envelop, Mission mission) {
        if (envelop.valid()) {
            String address = mission.getOutcomeAddress();
            if (Ut.isNil((String)address)) {
                Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 5. Output directly, ignore next EventBus steps", new Object[]{mission.getCode()}));
                return Future.succeededFuture((Object)envelop);
            }
            LOGGER.info("[ Job ] {0} event bus enabled: {1}", new Object[]{"Outcome", address});
            Promise output = Promise.promise();
            EventBus eventBus = this.vertx.eventBus();
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 5. Output send to address {1}", new Object[]{mission.getCode(), address}));
            eventBus.request(address, (Object)envelop, Ux.Opt.on().delivery(), handler -> {
                if (handler.succeeded()) {
                    output.complete(((Message)handler.result()).body());
                } else {
                    output.complete((Object)Envelop.failure(handler.cause()));
                }
            });
            return output.future();
        }
        Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] Terminal with error: {1}", new Object[]{mission.getCode(), ((Object)((Object)envelop.error())).getClass().getName()}));
        return Ux.future(envelop);
    }
}

