/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.phase;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.job.phase.Input;
import io.vertx.up.uca.job.phase.OutPut;
import io.vertx.up.uca.job.phase.Pool;
import io.vertx.up.uca.job.phase.RunOn;

public class Phase {
    private transient Vertx vertx;
    private transient Mission mission;
    private transient Input input;
    private transient RunOn runOn;
    private transient OutPut output;

    private Phase() {
    }

    public static Phase start(String name) {
        return (Phase)Fn.pool(Pool.PHASES, (Object)name, Phase::new);
    }

    public Phase bind(Vertx vertx) {
        this.vertx = vertx;
        this.input = new Input(this.vertx);
        this.runOn = new RunOn(this.vertx);
        this.output = new OutPut(this.vertx);
        return this;
    }

    public Phase bind(Mission mission) {
        this.mission = mission;
        return this;
    }

    public Future<Envelop> inputAsync(Mission mission) {
        return this.input.inputAsync(mission);
    }

    public Future<Envelop> incomeAsync(Envelop envelop) {
        return this.input.incomeAsync(envelop, this.mission);
    }

    public Future<Envelop> invokeAsync(Envelop envelop) {
        return this.runOn.bind(this.input.underway()).invoke(envelop, this.mission);
    }

    public Future<Envelop> outcomeAsync(Envelop envelop) {
        return this.output.outcomeAsync(envelop, this.mission);
    }

    public Future<Envelop> outputAsync(Envelop envelop) {
        return this.output.bind(this.input.underway()).outputAsync(envelop, this.mission);
    }

    public Future<Envelop> callbackAsync(Envelop envelop) {
        return this.runOn.callback(envelop, this.mission);
    }
}

