/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.store;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.store.JobConfig;
import io.vertx.up.uca.job.store.JobStore;
import io.vertx.up.uca.job.store.UnityStore;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;

public class JobPin {
    private static final Annal LOGGER = Annal.get(JobPin.class);
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final String JOB = "job";
    private static transient JobConfig CONFIG;
    private static transient JobStore STORE;

    public static JobConfig getConfig() {
        return CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobStore getStore() {
        Class<JobStore> clazz = JobStore.class;
        synchronized (JobStore.class) {
            if (null == STORE) {
                STORE = new UnityStore();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return STORE;
        }
    }

    public static boolean isIn(Mission mission) {
        return JobPool.valid(mission);
    }

    static {
        JsonObject config = (JsonObject)VISITOR.read();
        if (config.containsKey(JOB)) {
            JsonObject job = config.getJsonObject(JOB);
            CONFIG = !Ut.isNil((JsonObject)job) ? (JobConfig)Ut.deserialize((JsonObject)job, JobConfig.class) : new JobConfig();
            LOGGER.info("[ Job ] Job configuration read : {0}", new Object[]{CONFIG});
        }
    }
}

