/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.store;

import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.store.CodeStore;
import io.vertx.up.uca.job.store.ExtensionStore;
import io.vertx.up.uca.job.store.JobReader;
import io.vertx.up.uca.job.store.JobStore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class UnityStore
implements JobStore {
    private static final Annal LOGGER = Annal.get(UnityStore.class);
    private final transient JobReader reader = new CodeStore();
    private final transient JobStore store = new ExtensionStore();

    UnityStore() {
    }

    @Override
    public Set<Mission> fetch() {
        Set missions = this.reader.fetch().stream().filter(Mission::isReadOnly).collect(Collectors.toSet());
        LOGGER.info("[ Job ] The system scanned {0} jobs with type {1}", new Object[]{missions.size(), "Programming"});
        Set storage = this.store.fetch().stream().filter(mission -> !mission.isReadOnly()).collect(Collectors.toSet());
        LOGGER.info("[ Job ] The system scanned {0} jobs with type {1}", new Object[]{storage.size(), "Dynamic/Stored"});
        HashSet<Mission> result = new HashSet<Mission>();
        result.addAll(missions);
        result.addAll(storage);
        result.stream().filter(mission -> JobType.ONCE == mission.getType()).filter(mission -> JobStatus.STARTING == mission.getStatus()).forEach(mission -> mission.setStatus(JobStatus.STOPPED));
        JobPool.put(result);
        return result;
    }

    @Override
    public JobStore add(Mission mission) {
        JobPool.save(mission);
        return this.store.add(mission);
    }

    @Override
    public Mission fetch(String name) {
        return JobPool.get(name, () -> {
            Mission mission = this.reader.fetch(name);
            if (Objects.isNull(mission)) {
                mission = this.store.fetch(name);
            }
            return mission;
        });
    }

    @Override
    public JobStore remove(Mission mission) {
        JobPool.remove(mission.getCode());
        return this.store.remove(mission);
    }

    @Override
    public JobStore update(Mission mission) {
        JobPool.save(mission);
        return this.store.update(mission);
    }
}

