/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Operator;

abstract class AbstractAction {
    protected final transient VertxDAO vertxDAO;
    protected final transient JqAnalyzer analyzer;

    protected AbstractAction(JqAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.vertxDAO = analyzer.vertxDAO();
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected <T> Future<T> successed(CompletableFuture<T> future) {
        Promise promise = Promise.promise();
        ((CompletableFuture)future.thenAcceptAsync(arg_0 -> ((Promise)promise).complete(arg_0))).exceptionally(ex -> this.failure((Throwable)ex, promise));
        return promise.future();
    }

    protected <T> Future<T> successed(CompletableFuture<Void> future, T input) {
        Promise promise = Promise.promise();
        ((CompletableFuture)future.thenAcceptAsync(nil -> promise.complete(input))).exceptionally(ex -> this.failure((Throwable)ex, promise));
        return promise.future();
    }

    private Void failure(Throwable ex, Promise promise) {
        this.logger().jvm(ex);
        promise.fail(ex);
        return null;
    }

    protected Collection<Object> parameters(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Arrays.asList(value);
    }

    protected DSLContext context() {
        return JooqInfix.getDSL();
    }

    protected Condition condition(JsonObject criteria) {
        return Ut.isNil((JsonObject)criteria) ? null : JooqCond.transform((JsonObject)criteria, this.analyzer::column);
    }

    protected Condition conditionAnd(JsonObject criteria) {
        return JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
    }
}

