/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionFetch;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class ActionDelete
extends AbstractAction {
    private final transient ActionFetch fetch;

    ActionDelete(JqAnalyzer analyzer) {
        super(analyzer);
        this.fetch = new ActionFetch(analyzer);
    }

    <T> Future<T> deleteAsync(T entity) {
        return this.successed(this.vertxDAO.deleteAsync(Arrays.asList(entity)), entity);
    }

    <T> T delete(T entity) {
        this.vertxDAO.delete(entity);
        return entity;
    }

    <T> Future<List<T>> deleteAsync(List<T> entity) {
        return this.successed(this.vertxDAO.deleteAsync(entity), entity);
    }

    <T> List<T> delete(List<T> entity) {
        this.vertxDAO.delete(entity);
        return entity;
    }

    <T, ID> Boolean deleteById(Collection<ID> ids) {
        this.vertxDAO.deleteById(ids);
        return Boolean.TRUE;
    }

    <T, ID> Future<Boolean> deleteByIdAsync(Collection<ID> ids) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(ids);
        return this.successed(future, Boolean.TRUE);
    }

    <T, ID> Future<Boolean> deleteByAsync(JsonObject criteria) {
        if (Ut.isNil((JsonObject)criteria)) {
            return Ux.future(Boolean.TRUE);
        }
        return this.fetch.fetchAsync(criteria).compose(list -> this.deleteAsync((List)list).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE)));
    }

    <T, ID> Boolean deleteBy(JsonObject criteria) {
        if (Ut.isNil((JsonObject)criteria)) {
            return Boolean.TRUE;
        }
        List entities = this.fetch.fetch(criteria);
        this.delete(entities);
        return Boolean.TRUE;
    }
}

