/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionQr;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Operator;

class ActionFetch
extends AbstractAction {
    private final transient ActionQr qr;

    ActionFetch(JqAnalyzer analyzer) {
        super(analyzer);
        this.qr = new ActionQr(analyzer);
    }

    <T> Future<List<T>> fetchAllAsync() {
        return this.successed(this.vertxDAO.findAllAsync());
    }

    <T> List<T> fetchAll() {
        return this.vertxDAO.findAll();
    }

    <T> Future<List<T>> fetchAsync(String field, Object value) {
        return this.successed(this.vertxDAO.fetchAsync(this.analyzer.column(field), this.parameters(value)));
    }

    <T> List<T> fetch(String field, Object value) {
        return this.vertxDAO.fetch(this.analyzer.column(field), new Object[]{this.parameters(value)});
    }

    <T> Future<List<T>> fetchAsync(JsonObject criteria) {
        return this.qr.searchAsync(criteria);
    }

    <T> List<T> fetch(JsonObject criteria) {
        return this.qr.search(criteria);
    }

    <T, ID> Future<T> fetchByIdAsync(ID id) {
        return this.successed(this.vertxDAO.findByIdAsync(id));
    }

    <T, ID> T fetchById(ID id) {
        return (T)this.vertxDAO.findById(id);
    }

    <T> Future<T> fetchOneAsync(String field, Object value) {
        return this.successed(this.vertxDAO.fetchOneAsync(this.analyzer.column(field), value));
    }

    <T> T fetchOne(String field, Object value) {
        return (T)this.vertxDAO.fetchOne(this.analyzer.column(field), value);
    }

    <T> Future<T> fetchOneAsync(JsonObject criteria) {
        Condition condition = JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
        return this.successed(this.vertxDAO.fetchOneAsync(condition));
    }

    <T> T fetchOne(JsonObject criteria) {
        Condition condition = JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
        return (T)this.context().selectFrom(this.vertxDAO.getTable()).where(new Condition[]{condition}).fetchOne(this.vertxDAO.mapper());
    }
}

