/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

class ActionInsert
extends AbstractAction {
    ActionInsert(JqAnalyzer analyzer) {
        super(analyzer);
    }

    <T> Future<T> insertAsync(T entity) {
        return this.successed(this.vertxDAO.insertAsync(this.uuid(entity)), entity);
    }

    <T> T insert(T entity) {
        this.vertxDAO.insert(this.uuid(entity));
        return entity;
    }

    <T> Future<List<T>> insertAsync(List<T> list) {
        return this.successed(this.vertxDAO.insertAsync(this.uuid((T)list)), list);
    }

    <T> List<T> insert(List<T> list) {
        this.vertxDAO.insert(this.uuid((T)list));
        return list;
    }

    private <T> List<T> uuid(List<T> list) {
        list.forEach(this::uuid);
        return list;
    }

    private <T> T uuid(T input) {
        if (Objects.nonNull(input)) {
            try {
                String primaryKey = this.analyzer.primary();
                String primaryField = Objects.isNull(primaryKey) ? null : primaryKey;
                Object keyValue = Ut.field(input, (String)primaryField);
                if (Objects.isNull(keyValue)) {
                    Ut.field(input, (String)"key", (Object)UUID.randomUUID().toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return input;
    }
}

