/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionQr;
import io.vertx.up.uca.jooq.AggregatorCount;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.util.JqFlow;
import io.vertx.up.unity.Ux;
import java.util.Objects;

class ActionSearch
extends AbstractAction {
    private static final String FIELD_LIST = "list";
    private static final String FIELD_COUNT = "count";
    private final transient ActionQr qr;
    private final transient AggregatorCount counter;

    ActionSearch(JqAnalyzer analyzer) {
        super(analyzer);
        this.qr = new ActionQr(analyzer);
        this.counter = new AggregatorCount(analyzer);
    }

    <T> Future<JsonObject> searchAsync(JsonObject query, JqFlow workflow) {
        return workflow.inputQrAsync(query).compose(inquiry -> {
            JsonObject response = new JsonObject();
            Future dataFuture = this.qr.searchAsync((Qr)inquiry).compose(workflow::outputAsync);
            JsonObject criteria = Objects.nonNull(inquiry.getCriteria()) ? inquiry.getCriteria().toJson() : new JsonObject();
            Future<Long> countFuture = this.counter.countAsync(criteria);
            return CompositeFuture.join((Future)dataFuture, countFuture).compose(result -> {
                JsonArray list = (JsonArray)result.resultAt(0);
                Long count = (Long)result.resultAt(1);
                response.put(FIELD_COUNT, count).put(FIELD_LIST, list);
                return Future.succeededFuture((Object)response);
            });
        }).otherwise(Ux.otherwise(new JsonObject()));
    }

    <T> JsonObject search(JsonObject query, JqFlow workflow) {
        JsonObject response = new JsonObject();
        Qr qr = workflow.inputQr(query);
        JsonArray list = workflow.output(this.qr.search(qr));
        Long count = this.counter.count(qr.getCriteria().toJson());
        response.put(FIELD_COUNT, count).put(FIELD_LIST, list);
        return response;
    }
}

