/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.exception.zero.JooqFieldMissingException;
import io.vertx.up.exception.zero.JooqMergeException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;

public class JqAnalyzer {
    private static final Annal LOGGER = Annal.get(JqAnalyzer.class);
    private static final ConcurrentMap<Integer, VertxDAO> DAO_POOL = new ConcurrentHashMap<Integer, VertxDAO>();
    private final transient VertxDAO vertxDAO;
    private final transient ConcurrentMap<String, String> mapping = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, String> revert = new ConcurrentHashMap<String, String>();
    private transient Mojo pojo;
    private transient Table<?> table;
    private transient ConcurrentMap<String, Field> fieldMap = new ConcurrentHashMap<String, Field>();
    private transient Class<?> entityCls;

    private JqAnalyzer(VertxDAO vertxDAO) {
        Class typeCls;
        this.vertxDAO = (VertxDAO)Fn.pool(DAO_POOL, (Object)vertxDAO.hashCode(), () -> vertxDAO);
        this.table = (Table)Ut.field((Object)this.vertxDAO, (String)"table");
        this.entityCls = typeCls = (Class)Ut.field((Object)this.vertxDAO, (String)"type");
        java.lang.reflect.Field[] fields = Ut.fields((Class)typeCls);
        Field[] columns = this.table.fields();
        for (int idx = 0; idx < columns.length; ++idx) {
            Field column = columns[idx];
            java.lang.reflect.Field field = fields[idx];
            this.fieldMap.put(field.getName(), column);
            this.mapping.put(field.getName(), column.getName());
            this.revert.put(column.getName(), field.getName());
        }
    }

    public static JqAnalyzer create(VertxDAO vertxDAO) {
        return new JqAnalyzer(vertxDAO);
    }

    public VertxDAO vertxDAO() {
        return this.vertxDAO;
    }

    public Vertx vertx() {
        return Objects.isNull(this.vertxDAO) ? null : this.vertxDAO.vertx();
    }

    public String table() {
        return this.table.getName();
    }

    public TreeSet<String> primarySet() {
        TreeSet primary = this.keySet(this.table.getPrimaryKey());
        return primary.isEmpty() ? new TreeSet() : primary;
    }

    public String primary() {
        TreeSet<String> primary = this.keySet(this.table.getPrimaryKey());
        return primary.isEmpty() ? null : primary.iterator().next();
    }

    public <T> Object primaryValue(T input) {
        String primaryField = this.primary();
        if (Objects.isNull(primaryField)) {
            return null;
        }
        return Ut.field(input, (String)primaryField);
    }

    public <T> List<Object> primaryValue(List<T> list) {
        ArrayList<Object> values = new ArrayList<Object>();
        list.stream().map(this::primaryValue).forEach(values::add);
        return values;
    }

    public List<TreeSet<String>> uniqueKey() {
        ArrayList<TreeSet<String>> keys = new ArrayList<TreeSet<String>>();
        this.table.getKeys().forEach(ukey -> {
            TreeSet<String> keySet = this.keySet((UniqueKey<?>)ukey);
            if (!keySet.isEmpty()) {
                keys.add(keySet);
            }
        });
        return keys;
    }

    private TreeSet<String> keySet(UniqueKey<?> uk) {
        TreeSet<String> keySet = new TreeSet<String>();
        uk.getFields().forEach(column -> {
            String field = this.revert.getOrDefault(column.getName(), null);
            if (Objects.nonNull(field)) {
                keySet.add(field);
            }
        });
        return keySet;
    }

    public Class<?> type() {
        return this.entityCls;
    }

    private String columnName(String field) {
        String targetField;
        if (null == this.pojo) {
            targetField = this.mapping.values().contains(field) ? field : (String)this.mapping.get(field);
        } else {
            String columnName;
            String actualField;
            String columnName2;
            ConcurrentMap inColumnMapping = this.pojo.getInColumn();
            ConcurrentMap inMapping = this.pojo.getIn();
            targetField = inMapping.containsKey(field) ? (Objects.isNull(columnName2 = (String)inColumnMapping.get(actualField = (String)inMapping.get(field))) ? field : columnName2) : (Objects.isNull(columnName = (String)inColumnMapping.get(field)) ? columnName : field);
        }
        return targetField;
    }

    public ConcurrentMap<String, Field> columns() {
        return this.fieldMap;
    }

    public Field column(String field) {
        Field found;
        String columnField = this.columnName(field);
        Fn.outUp((null == columnField ? 1 : 0) != 0, (Annal)LOGGER, JooqFieldMissingException.class, (Object[])new Object[]{UxJooq.class, field, Ut.field((Object)this.vertxDAO, (String)"type")});
        LOGGER.debug("( Pojo ) The field \"{0}\" has been hitted ( converted ) to \"{1}\"", new Object[]{field, columnField});
        if (field.equals(columnField)) {
            found = (Field)this.fieldMap.get(field);
        } else {
            String actualField = (String)this.revert.get(columnField);
            found = (Field)this.fieldMap.get(actualField);
        }
        if (Objects.isNull(found)) {
            found = DSL.field((Name)DSL.name((String)columnField));
        }
        return found;
    }

    public Field[] column(String ... fields) {
        ArrayList columnList = new ArrayList();
        Arrays.asList(fields).forEach(field -> {
            Field columnField = this.column((String)field);
            if (Objects.nonNull(columnField)) {
                columnList.add(columnField);
            }
        });
        return columnList.toArray(new Field[0]);
    }

    public void on(String pojo, Class<?> clazz) {
        if (Ut.isNil((String)pojo)) {
            this.pojo = null;
        } else {
            LOGGER.debug("( Pojo Bind ) Pojo up.god.file = {0} has been bind to dao {1}, Field mode enabled.", new Object[]{pojo, clazz});
            this.pojo = Mirror.create(UxJooq.class).mount(pojo).mojo().bindColumn(this.mapping);
            LOGGER.debug("( Pojo ) The analyzed result should be : Revert {0}", new Object[]{this.pojo.getIn(), this.pojo.getInColumn()});
        }
    }

    public <T> T copyEntity(T target, T updated) {
        Fn.outUp((null == updated ? 1 : 0) != 0, (Annal)LOGGER, JooqMergeException.class, (Object[])new Object[]{UxJooq.class, null == target ? null : target.getClass(), Ut.serialize(target)});
        return (T)Fn.getSemi((null == target && null == updated ? 1 : 0) != 0, (Annal)LOGGER, () -> null, () -> {
            JsonObject targetJson = null == target ? new JsonObject() : (JsonObject)Ut.serializeJson((Object)target);
            Table tableField = (Table)Ut.field((Object)this.vertxDAO, (String)"table");
            UniqueKey key = tableField.getPrimaryKey();
            key.getFields().stream().map(item -> ((TableField)item).getName()).filter(this.revert::containsKey).map(this.revert::get).forEach(item -> Ut.field((Object)updated, (String)item.toString(), null));
            JsonObject sourceJson = (JsonObject)Ut.serializeJson((Object)updated);
            targetJson.mergeIn(sourceJson, true);
            Class<?> type = null == target ? updated.getClass() : target.getClass();
            return Ut.deserialize((JsonObject)targetJson, type);
        });
    }

    public String pojoFile() {
        return this.pojoFile(null);
    }

    public String pojoFile(String pojoExternal) {
        if (Objects.isNull(pojoExternal)) {
            if (Objects.isNull(this.pojo)) {
                return "";
            }
            return this.pojo.getPojoFile();
        }
        return pojoExternal;
    }

    public Mojo pojo() {
        return this.pojo;
    }
}

