/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.atom.Kv;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.JqEdge;
import io.vertx.up.uca.jooq.util.JqOut;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectWhereStep;
import org.jooq.Table;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;

class JqJoinder {
    private final transient ConcurrentMap<Class<?>, JqAnalyzer> ANALYZERS = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, String> PREFIX_MAP = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<Class<?>, String> CLASS_MAP = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, Class<?>> NAME_MAP = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, String> FIELD_TABLE_MAP = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, String> COLUMN_MAP = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, Field> FIELD_MAP = new ConcurrentHashMap<String, Field>();
    private final transient List<String> TABLES = new ArrayList<String>();
    private final transient List<JqEdge> EDGES = new ArrayList<JqEdge>();
    private transient Kv<String, String> first;
    private JqJoinder talbe;

    JqJoinder() {
    }

    <T> JqJoinder add(Class<T> daoCls, String field) {
        this.putDao(daoCls);
        String firstTable = (String)this.CLASS_MAP.get(daoCls);
        this.first = Kv.create((Object)firstTable, (Object)field);
        return this;
    }

    <T> JqJoinder join(Class<?> daoCls, String field) {
        if (2 < this.ANALYZERS.size()) {
            throw new RuntimeException("Join table counter limitation! ");
        }
        this.putDao(daoCls);
        String toTable = (String)this.CLASS_MAP.get(daoCls);
        this.TABLES.add(toTable);
        JqEdge edge = new JqEdge();
        edge.setFrom((String)this.first.getKey(), (String)this.first.getValue());
        edge.setTo(toTable, field);
        this.EDGES.add(edge);
        return this;
    }

    private <T> void putDao(Class<T> daoCls) {
        VertxDAO vertxDAO = (VertxDAO)JooqInfix.getDao(daoCls);
        JqAnalyzer analyzer = JqAnalyzer.create(vertxDAO);
        String tableName = analyzer.table();
        this.ANALYZERS.put(daoCls, analyzer);
        this.CLASS_MAP.put(daoCls, tableName);
        this.NAME_MAP.put(tableName, daoCls);
        Integer size = this.ANALYZERS.size();
        String tableAlias = "T" + size;
        this.PREFIX_MAP.put(tableName, DSL.table((String)tableAlias).getName());
        ConcurrentMap<String, Field> fields = analyzer.columns();
        for (String fieldName : fields.keySet()) {
            Field field = (Field)fields.get(fieldName);
            this.FIELD_MAP.put(fieldName, field);
            if (this.FIELD_TABLE_MAP.containsKey(field.getName())) continue;
            this.FIELD_TABLE_MAP.put(field.getName(), tableAlias);
            this.COLUMN_MAP.put(field.getName(), fieldName);
        }
    }

    <T> JqJoinder pojo(Class<?> daoCls, String pojo) {
        JqAnalyzer analyzer = (JqAnalyzer)this.ANALYZERS.get(daoCls);
        if (Objects.nonNull(analyzer)) {
            analyzer.on(pojo, daoCls);
        }
        return this;
    }

    Future<JsonObject> searchPaginationAsync(Qr qr, Mojo mojo) {
        JsonObject response = new JsonObject();
        JsonArray data = this.searchArray(qr, mojo);
        response.put("list", data);
        Integer counter = this.searchCount(qr);
        response.put("count", counter);
        return Ux.future(response);
    }

    private Integer searchCount(Qr qr) {
        DSLContext context = JooqInfix.getDSL();
        Table<Record> table = this.getTable();
        if (Objects.isNull(table)) {
            throw new RuntimeException("Table null issue! ");
        }
        Field original = (Field)this.FIELD_MAP.get(this.first.getValue());
        Field field = DSL.field((String)((String)this.PREFIX_MAP.get(this.first.getKey()) + "." + original.getName()));
        SelectJoinStep started = context.select((SelectField)field).from(table);
        if (null != qr.getCriteria()) {
            Condition condition = JooqCond.transform((JsonObject)qr.getCriteria().toJson(), this::getColumn, this::getTable);
            started.where(new Condition[]{condition});
        }
        return started.fetchCount();
    }

    JsonArray searchArray(Qr qr, Mojo mojo) {
        DSLContext context = JooqInfix.getDSL();
        Table<Record> table = this.getTable();
        if (Objects.isNull(table)) {
            throw new RuntimeException("Table null issue! ");
        }
        SelectWhereStep started = context.selectFrom(table);
        if (null != qr.getCriteria()) {
            Condition condition = JooqCond.transform((JsonObject)qr.getCriteria().toJson(), this::getColumn, this::getTable);
            started.where(new Condition[]{condition});
        }
        if (null != qr.getSorter()) {
            List orders = JooqCond.orderBy((Sorter)qr.getSorter(), this::getColumn, this::getTable);
            started.orderBy((Collection)orders);
        }
        if (null != qr.getPager()) {
            Pager pager = qr.getPager();
            started.offset(pager.getStart()).limit(pager.getSize());
        }
        Result records = started.fetch();
        Set projectionSet = qr.getProjection();
        JsonArray projection = Objects.isNull(projectionSet) ? new JsonArray() : Ut.toJArray((Set)projectionSet);
        return JqOut.toJoin((List<Record>)records, projection, this.COLUMN_MAP, mojo);
    }

    private Field getColumn(String field) {
        Field found = (Field)this.FIELD_MAP.get(field);
        if (Objects.isNull(found)) {
            return null;
        }
        return found;
    }

    private String getTable(String field) {
        return (String)this.FIELD_TABLE_MAP.get(field);
    }

    private Table<Record> getTable() {
        if (!this.PREFIX_MAP.isEmpty()) {
            Table<Record> first = this.getTableRecord((String)this.first.getKey());
            if (this.TABLES.isEmpty()) {
                return first;
            }
            int size = this.TABLES.size();
            String tableName = this.TABLES.get(0);
            Table<Record> record = this.getTableRecord(tableName);
            TableOnConditionStep<Record> conditionStep = this.buildCondition(first, record, this.EDGES.get(0));
            for (int idx = 1; idx < size; ++idx) {
                String middleName = this.TABLES.get(idx);
                Table<Record> next = this.getTableRecord(middleName);
                conditionStep = this.buildCondition((Table<Record>)conditionStep, next, this.EDGES.get(idx));
            }
            return conditionStep;
        }
        return null;
    }

    private TableOnConditionStep<Record> buildCondition(Table<Record> from, Table<Record> to, JqEdge edge) {
        String majorField = edge.getFromField();
        JqAnalyzer major = this.findByName(edge.getFromTable());
        Field hitted = major.column(majorField);
        String fromPrefix = (String)this.PREFIX_MAP.get(edge.getFromTable());
        Field hittedField = DSL.field((String)(fromPrefix + "." + hitted.getName()));
        String toField = edge.getToField();
        JqAnalyzer toTable = this.findByName(edge.getToTable());
        Field joined = toTable.column(toField);
        String toPrefix = (String)this.PREFIX_MAP.get(edge.getToTable());
        Field joinedField = DSL.field((String)(toPrefix + "." + joined.getName()));
        return from.leftJoin(to).on(new Condition[]{hittedField.eq(joinedField)});
    }

    private Table<Record> getTableRecord(String table) {
        String alias = (String)this.PREFIX_MAP.get(table);
        return DSL.table((Name)DSL.name((String)table)).as(DSL.name((String)alias));
    }

    private JqAnalyzer findByName(String name) {
        Class daoCls = (Class)this.NAME_MAP.get(name);
        return (JqAnalyzer)this.ANALYZERS.get(daoCls);
    }
}

