/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.util;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.util.JqTool;
import io.vertx.up.uca.jooq.util.Pool;
import io.vertx.up.unity.Ux;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JqFlow {
    private transient JqAnalyzer analyzer;
    private transient String pojo;

    private JqFlow(JqAnalyzer analyzer, String pojo) {
        this.analyzer = analyzer;
        this.pojo = pojo;
    }

    public static JqFlow create(JqAnalyzer analyzer) {
        return JqFlow.create(analyzer, analyzer.pojoFile());
    }

    public static JqFlow create(JqAnalyzer analyzer, String pojo) {
        Class<?> entityCls = analyzer.type();
        String normalized = analyzer.pojoFile(pojo);
        return (JqFlow)Fn.pool(Pool.POOL_FLOW, (Object)(entityCls.getName() + "," + normalized), () -> new JqFlow(analyzer, normalized));
    }

    public JqFlow on(JqAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.pojo = analyzer.pojoFile();
        return this;
    }

    public <T> T input(JsonObject data) {
        Class<?> entityCls = this.analyzer.type();
        return (T)Ux.fromJson(data, entityCls, this.pojo);
    }

    public <T> Future<T> inputAsync(JsonObject data) {
        return Future.succeededFuture(this.input(data));
    }

    public <T> List<T> input(JsonArray data) {
        Class<?> entityCls = this.analyzer.type();
        return Ux.fromJson(data, entityCls, this.pojo);
    }

    public <T> Future<List<T>> inputAsync(JsonArray data) {
        return Future.succeededFuture(this.input(data));
    }

    public Qr inputQr(JsonObject input) {
        return JqTool.qr(input, this.pojo);
    }

    public JsonObject inputQrJ(JsonObject criteria) {
        return JqTool.criteria(criteria, this.pojo);
    }

    public Future<Qr> inputQrAsync(JsonObject input) {
        return Future.succeededFuture((Object)this.inputQr(input));
    }

    public Future<JsonObject> inputQrJAsync(JsonObject criteria) {
        return Future.succeededFuture((Object)this.inputQrJ(criteria));
    }

    public <T> JsonObject output(T input) {
        return Ux.toJson(input, this.pojo);
    }

    public <T> Future<JsonObject> outputAsync(T input) {
        return Future.succeededFuture((Object)this.output(input));
    }

    public <T> JsonArray output(List<T> input) {
        return Ux.toJson(input, this.pojo);
    }

    public <T> ConcurrentMap<String, JsonArray> output(ConcurrentMap<String, List<T>> input) {
        ConcurrentHashMap<String, JsonArray> map = new ConcurrentHashMap<String, JsonArray>();
        input.forEach((field, list) -> {
            JsonArray groupData = Ux.toJson(list, this.pojo);
            map.put((String)field, groupData);
        });
        return map;
    }

    public <T> Future<ConcurrentMap<String, JsonArray>> outputAsync(ConcurrentMap<String, List<T>> input) {
        return Future.succeededFuture(this.output(input));
    }

    public <T> Future<JsonArray> outputAsync(List<T> input) {
        return Future.succeededFuture((Object)this.output(input));
    }
}

