/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.util;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.util.JqFlow;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public class JqTool {
    private static final Annal LOGGER = Annal.get(JqTool.class);

    public static <T> CompositeFuture joinAsync(JsonObject criteria, JsonObject data, JqFlow flow) {
        Future<JsonObject> criteriaFuture = flow.inputQrJAsync(criteria);
        Future dataFuture = flow.inputAsync(data);
        return CompositeFuture.join(criteriaFuture, dataFuture);
    }

    public static <T> CompositeFuture joinAsync(JsonObject criteria, JsonArray data, JqFlow flow) {
        Future<JsonObject> criteriaFuture = flow.inputQrJAsync(criteria);
        Future dataFuture = flow.inputAsync(data);
        return CompositeFuture.join(criteriaFuture, dataFuture);
    }

    public static Qr qr(JsonObject envelop, String pojo) {
        return (Qr)Fn.getNull((Object)Qr.create((JsonObject)new JsonObject()), () -> {
            JsonObject data = envelop.copy();
            if (Ut.isNil((String)pojo)) {
                return Qr.create((JsonObject)data);
            }
            Mojo mojo = Mirror.create(JqTool.class).mount(pojo).mojo();
            return JqTool.qr(data, mojo);
        }, (Object[])new Object[]{envelop});
    }

    public static JsonObject criteria(JsonObject criteria, String pojo) {
        Qr qr = JqTool.qr(new JsonObject().put("criteria", criteria), pojo);
        return Objects.isNull(qr.getCriteria()) ? new JsonObject() : qr.getCriteria().toJson();
    }

    public static Qr qr(JsonObject data, Mojo mojo) {
        if (data.containsKey("projection")) {
            data.put("projection", JqTool.projection(data.getJsonArray("projection"), mojo));
        }
        if (data.containsKey("sorter")) {
            data.put("sorter", JqTool.sorter(data.getJsonArray("sorter"), mojo));
        }
        if (data.containsKey("criteria")) {
            data.put("criteria", JqTool.criteria(data.getJsonObject("criteria"), mojo));
        }
        LOGGER.info("( Qr ) Processed metadata = {0}.", new Object[]{data.encode()});
        return Qr.create((JsonObject)data);
    }

    public static JsonObject criteria(JsonObject criteria, Mojo mojo) {
        JsonObject criterias = new JsonObject();
        ConcurrentMap mapping = mojo.getIn();
        for (String field : criteria.fieldNames()) {
            String key;
            String string = key = field.contains(",") ? field.split(",")[0] : field;
            if (mapping.containsKey(key)) {
                String targetField = field.contains(",") ? (String)mapping.get(key) + "," + field.split(",")[1] : (String)mapping.get(key);
                criterias.put(targetField, criteria.getValue(field));
                continue;
            }
            if (Ut.isJObject((Object)criteria.getValue(field)) || field.equals("")) {
                if (Ut.isJObject((Object)criteria.getValue(field))) {
                    JsonObject valueJson = criteria.getJsonObject(field);
                    criterias.put(field, JqTool.criteria(valueJson, mojo));
                    continue;
                }
                criterias.put(field, criteria.getValue(field));
                continue;
            }
            criterias.put(field, criteria.getValue(field));
        }
        return criterias;
    }

    private static JsonArray projection(JsonArray projections, Mojo mojo) {
        JsonArray result = new JsonArray();
        ConcurrentMap mapping = mojo.getIn();
        Ut.itJArray((JsonArray)projections, String.class, (item, index) -> result.add(null == mapping.get(item) ? item : (String)mapping.get(item)));
        return result;
    }

    private static JsonArray sorter(JsonArray sorter, Mojo mojo) {
        JsonArray sorters = new JsonArray();
        ConcurrentMap mapping = mojo.getIn();
        Ut.itJArray((JsonArray)sorter, String.class, (item, index) -> {
            String key;
            String string = key = item.contains(",") ? item.split(",")[0] : item;
            if (mapping.containsKey(key)) {
                String targetField = (String)mapping.get(key);
                if (item.contains(",")) {
                    sorters.add(targetField + "," + item.split(",")[1]);
                } else {
                    sorters.add(targetField + "," + "ASC");
                }
            } else {
                sorters.add(item);
            }
        });
        return sorters;
    }
}

