/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.registry;

import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.uca.registry.UddiClient;
import io.vertx.up.uca.registry.UddiConfig;
import io.vertx.up.uca.registry.UddiEmpty;
import io.vertx.up.uca.registry.UddiJet;
import io.vertx.up.uca.registry.UddiRegistry;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class Uddi {
    public static UddiRegistry registry(Class<?> caller) {
        Class<?> componentCls = UddiConfig.registry();
        if (Objects.isNull(componentCls)) {
            return (UddiRegistry)Ut.singleton(UddiEmpty.class, (Object[])new Object[0]);
        }
        return (UddiRegistry)Ut.singleton(componentCls, (Object[])new Object[]{caller});
    }

    public static UddiJet discovery(Class<?> caller) {
        Class<?> componentCls = UddiConfig.jet();
        if (Objects.isNull(componentCls) || !Ut.isImplement(componentCls, UddiJet.class)) {
            throw new _500InternalServerException(caller, "Null or not UddiJet");
        }
        return (UddiJet)Ut.instance(componentCls, (Object[])new Object[0]);
    }

    public static UddiClient client(Class<?> caller) {
        Class<?> componentCls = UddiConfig.client();
        if (Objects.isNull(componentCls) || !Ut.isImplement(componentCls, UddiClient.class)) {
            throw new _500InternalServerException(caller, "Null or not UddiClient");
        }
        return (UddiClient)Ut.instance(componentCls, (Object[])new Object[]{caller});
    }
}

