/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.config;

import io.reactivex.Observable;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.tp.error.EventCodexMultiException;
import io.vertx.up.annotations.Adjust;
import io.vertx.up.annotations.Codex;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroHelper;
import io.vertx.up.uca.container.Virtual;
import io.vertx.up.uca.rs.Extractor;
import io.vertx.up.uca.rs.config.MediaResolver;
import io.vertx.up.uca.rs.config.MethodResolver;
import io.vertx.up.uca.rs.config.PathResolver;
import io.vertx.up.uca.rs.config.Verifier;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.EventSourceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Path;

public class EventExtractor
implements Extractor<Set<Event>> {
    private static final Annal LOGGER = Annal.get(EventExtractor.class);

    @Override
    public Set<Event> extract(Class<?> clazz) {
        return (Set)Fn.getNull((Object)new ConcurrentHashSet(), () -> {
            this.verify(clazz);
            ConcurrentHashSet result = new ConcurrentHashSet();
            Fn.safeSemi((boolean)clazz.isAnnotationPresent(Path.class), (Annal)LOGGER, () -> this.lambda$null$0(clazz, (Set)result), () -> this.lambda$null$1((Set)result, clazz));
            return result;
        }, (Object[])new Object[]{clazz});
    }

    private void verify(Class<?> clazz) {
        if (!clazz.isInterface()) {
            Verifier.noArg(clazz, this.getClass());
        }
        Verifier.modifier(clazz, this.getClass());
        Fn.outUp((!clazz.isAnnotationPresent(EndPoint.class) ? 1 : 0) != 0, (Annal)LOGGER, EventSourceException.class, (Object[])new Object[]{this.getClass(), clazz.getName()});
    }

    private Set<Event> extract(Class<?> clazz, String root) {
        Long counter;
        ConcurrentHashSet events = new ConcurrentHashSet();
        Object[] methods = clazz.getDeclaredMethods();
        Fn.outUp(((long)methods.length < (counter = (Long)Observable.fromArray((Object[])methods).map(Method::getParameterAnnotations).flatMap(Observable::fromArray).map(Arrays::asList).map(item -> item.stream().map(Annotation::annotationType).collect(Collectors.toList())).filter(item -> item.contains(Codex.class)).count().blockingGet()) ? 1 : 0) != 0, (Annal)LOGGER, EventCodexMultiException.class, (Object[])new Object[]{this.getClass(), clazz});
        events.addAll(Arrays.stream(methods).filter(MethodResolver::isValid).map(item -> this.extract((Method)item, root)).filter(Objects::nonNull).collect(Collectors.toSet()));
        return events;
    }

    private Event extract(Method method, String root) {
        Adjust adjust;
        Integer order;
        Class implClass;
        Event event = new Event();
        HttpMethod httpMethod = MethodResolver.resolve(method);
        if (null == httpMethod) {
            return null;
        }
        event.setMethod(httpMethod);
        Path path = ZeroHelper.getPath(method);
        if (null == path) {
            if (!Ut.isNil((String)root)) {
                event.setPath(root);
            }
        } else {
            String result = PathResolver.resolve(path, root);
            event.setPath(result);
        }
        event.setAction(method);
        event.setConsumes(MediaResolver.consumes(method));
        event.setProduces(MediaResolver.produces(method));
        Class<?> clazz = method.getDeclaringClass();
        Object proxy = clazz.isInterface() ? (null != (implClass = Ut.childUnique(clazz)) ? Ut.singleton((Class)implClass, (Object[])new Object[0]) : Virtual.create()) : Ut.singleton(method.getDeclaringClass(), (Object[])new Object[0]);
        event.setProxy(proxy);
        if (method.isAnnotationPresent(Adjust.class) && Objects.nonNull(order = (Integer)Ut.invoke((Object)(adjust = method.getDeclaredAnnotation(Adjust.class)), (String)"value", (Object[])new Object[0]))) {
            event.setOrder(order);
        }
        return event;
    }

    private /* synthetic */ void lambda$null$1(Set result, Class clazz) {
        result.addAll(this.extract(clazz, null));
    }

    private /* synthetic */ void lambda$null$0(Class clazz, Set result) {
        Path path = ZeroHelper.getPath(clazz);
        assert (null != path) : "Path should not be null.";
        result.addAll(this.extract(clazz, PathResolver.resolve(path)));
    }
}

