/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.hunt;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.up.commune.Envelop;
import io.vertx.up.uca.rs.hunt.adaptor.WingSelector;
import io.vertx.up.uca.rs.hunt.adaptor.Wings;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.MediaType;

final class Outcome {
    Outcome() {
    }

    static void media(HttpServerResponse response, Set<MediaType> produces) {
        if (!response.headWritten()) {
            if (produces.isEmpty()) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            } else if (produces.contains(MediaType.WILDCARD_TYPE)) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            } else {
                MediaType type = produces.iterator().next();
                if (Objects.isNull(type)) {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
                } else {
                    String content = type.getType() + "/" + type.getSubtype();
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)content);
                }
            }
        }
    }

    static void security(HttpServerResponse response) {
        if (!response.headWritten()) {
            response.putHeader("Cache-Control", "no-store, no-cache").putHeader("X-Content-Type-Options", "nosniff").putHeader("Strict-Transport-Security", "max-age=15768000").putHeader("X-Download-Options", "noopen").putHeader("X-XSS-Protection", "1; mode=block").putHeader("X-FRAME-OPTIONS", "DENY");
        }
    }

    static void out(HttpServerResponse response, Envelop envelop, Set<MediaType> produces) {
        if (!response.headWritten() && !response.ended()) {
            if (HttpMethod.HEAD == envelop.method()) {
                response.setStatusCode(HttpStatusCode.NO_CONTENT.code());
                response.setStatusMessage(HttpStatusCode.NO_CONTENT.message());
                response.end("");
            } else {
                String headerStr = response.headers().get(HttpHeaders.CONTENT_TYPE);
                Wings wings = WingSelector.end(headerStr, produces);
                wings.output(response, envelop);
            }
        }
        response.closed();
    }
}

