/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.router;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.TimeoutHandler;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.tp.plugin.session.SessionClient;
import io.vertx.tp.plugin.session.SessionInfix;
import io.vertx.up.runtime.ZeroHeart;
import io.vertx.up.secure.config.CorsConfig;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RouterAxis
implements Axis<Router> {
    private static final CorsConfig CONFIG = CorsConfig.get();
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private final transient Vertx vertx;

    public RouterAxis(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void mount(Router router) {
        this.mountSession(router);
        router.route().order(1300000).handler((Handler)BodyHandler.create().setBodyLimit(0x2000000L));
        router.route().order(1400000).handler((Handler)ResponseContentTypeHandler.create());
        this.mountCors(router);
    }

    private void mountTimeout(Router router) {
        router.route().order(1050000).handler((Handler)TimeoutHandler.create((long)10000L));
    }

    private void mountSession(Router router) {
        if (ZeroHeart.isSession()) {
            SessionClient client = SessionInfix.getOrCreate(this.vertx);
            router.route().order(1600000).handler((Handler)client.getHandler());
        } else {
            Object store = this.vertx.isClustered() ? ClusteredSessionStore.create((Vertx)this.vertx) : LocalSessionStore.create((Vertx)this.vertx);
            router.route().order(1600000).handler((Handler)SessionHandler.create((SessionStore)store));
        }
    }

    private void mountCors(Router router) {
        router.route().order(1100000).handler((Handler)CorsHandler.create((String)CONFIG.getOrigin()).allowCredentials(CONFIG.getCredentials().booleanValue()).allowedHeaders(this.getAllowedHeaders(CONFIG.getHeaders())).allowedMethods(this.getAllowedMethods(CONFIG.getMethods())));
    }

    private Set<String> getAllowedHeaders(JsonArray array) {
        HashSet<String> headerSet = new HashSet<String>();
        array.stream().filter(Objects::nonNull).map(item -> (String)item).forEach(headerSet::add);
        return headerSet;
    }

    private Set<HttpMethod> getAllowedMethods(JsonArray array) {
        HashSet<HttpMethod> methodSet = new HashSet<HttpMethod>();
        array.stream().filter(Objects::nonNull).map(item -> (String)item).map(item -> (HttpMethod)Ut.toEnum(() -> item, HttpMethod.class, (Enum)HttpMethod.GET)).forEach(methodSet::add);
        return methodSet;
    }
}

