/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.router.monitor;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.ext.web.Router;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.monitor.Quota;

public class ServiceAxis
implements Axis<Router> {
    private final transient Vertx vertx;
    private final transient HealthChecks healthChecks;

    public ServiceAxis(Vertx vertx) {
        this.vertx = vertx;
        this.healthChecks = HealthChecks.create((Vertx)vertx);
        this.healthChecks.register("pool/habitus", (Handler)Quota.pool(vertx, "vertx-web.sessions.habitus"));
    }

    @Override
    public void mount(Router router) {
        HealthCheckHandler handler = HealthCheckHandler.createWithHealthChecks((HealthChecks)this.healthChecks);
        router.get("/zero/health*").order(1000000).produces("application/json").handler((Handler)handler);
    }
}

