/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.validation;

import io.vertx.up.log.Annal;
import io.vertx.up.uca.rs.validation.ValidatorMessager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.el.ELManager;
import javax.el.ExpressionFactory;
import javax.validation.MessageInterpolator;
import org.hibernate.validator.internal.engine.messageinterpolation.InterpolationTerm;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class ValidatorInterpolator
extends ValidatorMessager {
    private static final Annal LOGGER = Annal.get(ValidatorInterpolator.class);
    private final ExpressionFactory expressionFactory;

    public ValidatorInterpolator() {
        this.expressionFactory = ValidatorInterpolator.buildExpressionFactory();
    }

    public ValidatorInterpolator(ResourceBundleLocator userResourceBundleLocator) {
        super(userResourceBundleLocator);
        this.expressionFactory = ValidatorInterpolator.buildExpressionFactory();
    }

    public ValidatorInterpolator(ResourceBundleLocator userResourceBundleLocator, ResourceBundleLocator contributorResourceBundleLocator) {
        super(userResourceBundleLocator, contributorResourceBundleLocator);
        this.expressionFactory = ValidatorInterpolator.buildExpressionFactory();
    }

    public ValidatorInterpolator(ResourceBundleLocator userResourceBundleLocator, ResourceBundleLocator contributorResourceBundleLocator, boolean cachingEnabled) {
        super(userResourceBundleLocator, contributorResourceBundleLocator, cachingEnabled);
        this.expressionFactory = ValidatorInterpolator.buildExpressionFactory();
    }

    public ValidatorInterpolator(ResourceBundleLocator userResourceBundleLocator, boolean cachingEnabled) {
        super(userResourceBundleLocator, null, cachingEnabled);
        this.expressionFactory = ValidatorInterpolator.buildExpressionFactory();
    }

    public ValidatorInterpolator(ResourceBundleLocator userResourceBundleLocator, boolean cachingEnabled, ExpressionFactory expressionFactory) {
        super(userResourceBundleLocator, null, cachingEnabled);
        this.expressionFactory = expressionFactory;
    }

    private static ExpressionFactory buildExpressionFactory() {
        if (ValidatorInterpolator.canLoadExpressionFactory()) {
            ExpressionFactory expressionFactory = ELManager.getExpressionFactory();
            LOGGER.debug("Loaded expression factory via original TCCL", new Object[0]);
            return expressionFactory;
        }
        ClassLoader originalContextClassLoader = (ClassLoader)ValidatorInterpolator.run(GetClassLoader.fromContext());
        try {
            ValidatorInterpolator.run(SetContextClassLoader.action((ClassLoader)ResourceBundleMessageInterpolator.class.getClassLoader()));
            if (ValidatorInterpolator.canLoadExpressionFactory()) {
                ExpressionFactory var2;
                ExpressionFactory expressionFactory = ELManager.getExpressionFactory();
                LOGGER.debug("Loaded expression factory via HV classloader", new Object[0]);
                ExpressionFactory expressionFactory2 = var2 = expressionFactory;
                return expressionFactory2;
            }
            ValidatorInterpolator.run(SetContextClassLoader.action((ClassLoader)ELManager.class.getClassLoader()));
            if (ValidatorInterpolator.canLoadExpressionFactory()) {
                ExpressionFactory var2;
                ExpressionFactory expressionFactory = ELManager.getExpressionFactory();
                LOGGER.debug("Loaded expression factory via EL classloader", new Object[0]);
                ExpressionFactory expressionFactory3 = var2 = expressionFactory;
                return expressionFactory3;
            }
        }
        catch (Throwable var6) {
            LOGGER.jvm(var6);
            throw var6;
        }
        finally {
            ValidatorInterpolator.run(SetContextClassLoader.action((ClassLoader)originalContextClassLoader));
        }
        throw new RuntimeException("Expression Factory error.");
    }

    private static boolean canLoadExpressionFactory() {
        try {
            ExpressionFactory.newInstance();
            return true;
        }
        catch (Throwable var1) {
            return false;
        }
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    @Override
    public String interpolate(MessageInterpolator.Context context, Locale locale, String term) {
        InterpolationTerm expression = new InterpolationTerm(term, locale, this.expressionFactory);
        return expression.interpolate(context);
    }
}

