/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.anima;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Verticles {
    private static final ConcurrentMap<Class<?>, String> INSTANCES = new ConcurrentHashMap();

    Verticles() {
    }

    static void deploy(Vertx vertx, Class<?> clazz, DeploymentOptions option, Annal logger) {
        String flag;
        String name = clazz.getName();
        String string = flag = option.isWorker() ? "Worker" : "Agent";
        if (option.isWorker()) {
            option.setMultiThreaded(true);
        }
        vertx.deployVerticle(name, option, result -> {
            if (result.succeeded()) {
                logger.info("( {3} ) The verticle {0} has been deployed {1} instances successfully. id = {2}.", new Object[]{name, option.getInstances(), result.result(), flag});
                INSTANCES.put(clazz, (String)result.result());
            } else {
                if (null != result.cause()) {
                    result.cause().printStackTrace();
                }
                logger.warn("( {3} ) The verticle {0} has been deployed {1} instances failed. id = {2}, cause = {3}.", new Object[]{name, option.getInstances(), result.result(), null == result.cause() ? null : result.cause().getMessage(), flag});
            }
        });
    }

    static void undeploy(Vertx vertx, Class<?> clazz, DeploymentOptions option, Annal logger) {
        String name = clazz.getName();
        String flag = option.isWorker() ? "Worker" : "Agent";
        String id = (String)INSTANCES.get(clazz);
        Fn.safeNull(() -> vertx.undeploy(id, result -> {
            if (result.succeeded()) {
                logger.info("( {2} ) The verticle {0} has been undeployed  successfully, id = {1}.", new Object[]{name, id, flag});
            }
        }), (Object[])new Object[]{id});
    }
}

