/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.thread;

import io.reactivex.Observable;
import io.vertx.up.annotations.Qualifier;
import io.vertx.up.eon.Plugins;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.MultiAnnotatedException;
import io.vertx.zero.exception.NamedImplementionException;
import io.vertx.zero.exception.NamedNotFoundException;
import io.vertx.zero.exception.QualifierMissedException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

public class AffluxThread
extends Thread {
    private static final Annal LOGGER = Annal.get(AffluxThread.class);
    private final ConcurrentMap<String, Class<?>> fieldMap = new ConcurrentHashMap();
    private final transient Class<?> reference;
    private final transient Set<Class<?>> namedSet;
    private final transient Set<Class<?>> classes;

    public AffluxThread(Class<?> clazz, Set<Class<?>> classes) {
        this.setName("zero-injection-scanner-" + this.getId());
        this.reference = clazz;
        this.classes = classes;
        this.namedSet = classes.stream().filter(item -> item.isAnnotationPresent(Named.class)).collect(Collectors.toSet());
    }

    @Override
    public void run() {
        if (null != this.reference) {
            List fields = Arrays.stream(this.reference.getDeclaredFields()).filter(field -> Plugins.INJECT_ANNOTATIONS.stream().anyMatch(field::isAnnotationPresent)).collect(Collectors.toList());
            for (Field field2 : fields) {
                if (field2.isAnnotationPresent(Inject.class)) {
                    this.scanStandard(field2);
                    continue;
                }
                this.scanSpecific(field2);
            }
        }
    }

    private void scanStandard(Field field) {
        Class<?> type = field.getType();
        if (type.isInterface()) {
            List<Class<?>> target = this.classes.stream().filter(item -> Ut.isImplement((Class)item, (Class)type)).collect(Collectors.toList());
            if (target.isEmpty()) {
                String fieldName = field.getName();
                String typeName = field.getDeclaringClass().getName();
                LOGGER.warn("( Field ) JSR311 Warning, declared class: \"{0}\", field = \"{1}\", type = {2}", new Object[]{typeName, fieldName, type.getName()});
            } else if (1 == target.size()) {
                Class targetCls = (Class)target.get(0);
                LOGGER.info("( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), targetCls.getName(), Inject.class});
                this.fieldMap.put(field.getName(), targetCls);
            } else {
                this.scanQualifier(field, target);
            }
        } else {
            this.fieldMap.put(field.getName(), type);
            LOGGER.info("( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), type.getName(), Inject.class});
        }
    }

    private void scanQualifier(Field field, List<Class<?>> instanceCls) {
        List instanceNames = instanceCls.stream().map(Class::getName).collect(Collectors.toList());
        LOGGER.info("The instance classes ({0}) will be scanned.", new Object[]{Ut.fromJoin(instanceNames)});
        Qualifier annotation = field.getAnnotation(Qualifier.class);
        Fn.outUp((null == annotation ? 1 : 0) != 0, (Annal)LOGGER, QualifierMissedException.class, (Object[])new Object[]{this.getClass(), field.getName(), field.getDeclaringClass().getName()});
        boolean match = instanceCls.stream().allMatch(item -> item.isAnnotationPresent(Named.class));
        Set names = instanceCls.stream().map(Class::getName).collect(Collectors.toSet());
        Fn.outUp((!match ? 1 : 0) != 0, (Annal)LOGGER, NamedImplementionException.class, (Object[])new Object[]{this.getClass(), names, field.getType().getName()});
        String value = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        Optional<Class> verified = instanceCls.stream().filter(item -> {
            Named target = item.getAnnotation(Named.class);
            String targetValue = (String)Ut.invoke((Object)target, (String)"value", (Object[])new Object[0]);
            return value.equals(targetValue) && !Ut.isNil((String)targetValue);
        }).findAny();
        Fn.outUp((!verified.isPresent() ? 1 : 0) != 0, (Annal)LOGGER, NamedNotFoundException.class, (Object[])new Object[]{this.getClass(), names, value});
        this.fieldMap.put(field.getName(), verified.get());
    }

    private void scanSpecific(Field field) {
        Set defineds = Plugins.INFIX_MAP.keySet();
        Object[] annotations = field.getDeclaredAnnotations();
        HashSet set = new HashSet();
        Annotation hitted = (Annotation)Observable.fromArray((Object[])annotations).filter(annotation -> defineds.contains(annotation.annotationType())).map(annotation -> {
            set.add(annotation.annotationType().getName());
            return annotation;
        }).blockingFirst();
        Fn.outUp((1 < set.size() ? 1 : 0) != 0, (Annal)LOGGER, MultiAnnotatedException.class, (Object[])new Object[]{this.getClass(), field.getName(), field.getDeclaringClass().getName(), set});
        LOGGER.info("( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), field.getDeclaringClass().getName(), hitted.annotationType().getName()});
        this.fieldMap.put(field.getName(), field.getType());
    }

    public ConcurrentMap<String, Class<?>> getFieldMap() {
        return this.fieldMap;
    }

    public Class<?> getClassKey() {
        return this.reference;
    }

    public boolean isEmpty() {
        return this.fieldMap.isEmpty();
    }
}

