/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Refer;
import io.vertx.up.fn.Fn;
import io.vertx.up.fn.wait.Case;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

class Async {
    private static final Annal LOGGER = Annal.get(Async.class);

    Async() {
    }

    static <T> Future<T> future(T input, Set<Function<T, Future<T>>> set) {
        ArrayList futures = new ArrayList();
        set.stream().map(consumer -> (Future)consumer.apply(input)).forEach(futures::add);
        Ux.thenCombineT(futures).compose(nil -> {
            LOGGER.info("\u300cJob Plugin\u300d There are `{0}` jobs that are finished successfully!", new Object[]{String.valueOf(set.size())});
            return Ux.future(nil);
        });
        return Ux.future(input);
    }

    static <T> Future<T> future(T input, List<Function<T, Future<T>>> queues) {
        if (0 == queues.size()) {
            return To.future(input);
        }
        Future first = queues.get(0).apply(input);
        if (Objects.isNull(first)) {
            LOGGER.error("The index = 0 future<T> returned null, plugins will be terminal", new Object[0]);
            return To.future(input);
        }
        if (1 == queues.size()) {
            return first;
        }
        Refer response = new Refer();
        response.add(input);
        int idx = 1;
        while (idx < queues.size()) {
            int current = idx++;
            first = first.compose(json -> {
                Future future = (Future)((Function)queues.get(current)).apply(json);
                if (Objects.isNull(future)) {
                    return To.future(json);
                }
                return future.compose(arg_0 -> ((Refer)response).future(arg_0)).otherwise(Ux.otherwise(() -> response.add(json).get()));
            }).otherwise(Ux.otherwise(() -> response.get()));
        }
        return first;
    }

    static <T> Future<JsonObject> toJsonFuture(String pojo, CompletableFuture<T> completableFuture) {
        Promise future = Promise.promise();
        Fn.safeSemi((null == completableFuture ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonObject()), () -> ((CompletableFuture)completableFuture.thenAcceptAsync(item -> Fn.safeSemi((null == item ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonObject()), () -> future.complete((Object)To.toJObject(item, pojo))))).exceptionally(ex -> {
            LOGGER.jvm(ex);
            future.fail(ex);
            return null;
        }));
        return future.future();
    }

    static <T> Future<JsonArray> toArrayFuture(String pojo, CompletableFuture<List<T>> completableFuture) {
        Promise future = Promise.promise();
        Fn.safeSemi((null == completableFuture ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonArray()), () -> ((CompletableFuture)completableFuture.thenAcceptAsync(item -> Fn.safeSemi((null == item ? 1 : 0) != 0, null, () -> future.complete((Object)new JsonArray()), () -> future.complete((Object)To.toJArray(item, pojo))))).exceptionally(ex -> {
            LOGGER.jvm(ex);
            future.fail(ex);
            return null;
        }));
        return future.future();
    }

    static <T> Future<JsonObject> toUpsertFuture(T entity, String pojo, Supplier<Future<JsonObject>> supplier, Function<JsonObject, JsonObject> updateFun) {
        return Fn.match((Case.DefaultCase)Fn.fork(() -> Future.succeededFuture((Object)To.toJObject(entity, pojo)).compose(item -> null == updateFun ? Future.succeededFuture((Object)item) : Future.succeededFuture(updateFun.apply((JsonObject)item)))), (Case[])new Case[]{Fn.branch((null == entity ? 1 : 0) != 0, supplier)});
    }

    static <T> Function<Throwable, Future<T>> toErrorFuture(Supplier<T> input) {
        return ex -> {
            if (Objects.nonNull(ex)) {
                ex.printStackTrace();
            }
            return Future.succeededFuture(input.get());
        };
    }
}

