/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.FileUpload;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Upload {
    private static final Annal LOGGER = Annal.get(Upload.class);

    Upload() {
    }

    static <T> T toFile(Set<FileUpload> fileUploads, Class<?> expected, Function<String, Buffer> consumer) {
        if (Objects.isNull(fileUploads) || fileUploads.isEmpty()) {
            LOGGER.warn("The fileUploads set size is 0.", new Object[0]);
            if (Collection.class.isAssignableFrom(expected)) {
                if (List.class.isAssignableFrom(expected)) {
                    return (T)Collections.emptyList();
                }
                if (Set.class.isAssignableFrom(expected)) {
                    return (T)Collections.emptySet();
                }
                LOGGER.warn("The type {0} is not supported.", new Object[]{expected.getName()});
                return null;
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(expected)) {
            Stream<Object> stream = fileUploads.stream().map(fileUpload -> Upload.toFile(fileUpload, FileUpload.class, consumer));
            if (List.class.isAssignableFrom(expected)) {
                return (T)stream.collect(Collectors.toList());
            }
            if (Set.class.isAssignableFrom(expected)) {
                return (T)stream.collect(Collectors.toSet());
            }
            LOGGER.warn("The type {0} is not supported.", new Object[]{expected.getName()});
            return null;
        }
        if (!Upload.isByteArray(expected) && expected.isArray()) {
            if (expected.isArray()) {
                Class<?> componentCls = expected.getComponentType();
                ArrayList<FileUpload> fileList = new ArrayList<FileUpload>(fileUploads);
                if (File.class == componentCls) {
                    File[] files = new File[fileList.size()];
                    for (int idx = 0; idx < fileList.size(); ++idx) {
                        files[idx] = (File)Upload.toFile((FileUpload)fileList.get(idx), File.class, consumer);
                    }
                    return (T)files;
                }
                if (FileUpload.class.isAssignableFrom(componentCls)) {
                    FileUpload[] files = new FileUpload[fileList.size()];
                    for (int idx = 0; idx < fileList.size(); ++idx) {
                        files[idx] = (FileUpload)fileList.get(idx);
                    }
                    return (T)files;
                }
                return (T)fileUploads.stream().map(item -> Upload.toFile(item, componentCls, consumer)).toArray();
            }
            return Upload.toFile(fileUploads, expected, consumer);
        }
        FileUpload fileUpload2 = fileUploads.iterator().next();
        return Upload.toFile(fileUpload2, expected, consumer);
    }

    static ConcurrentMap<String, Set<FileUpload>> toFile(Set<FileUpload> fileUploads) {
        ConcurrentHashMap<String, Set<FileUpload>> fileMap = new ConcurrentHashMap<String, Set<FileUpload>>();
        fileUploads.stream().forEach(fileUpload -> {
            Set<FileUpload> set;
            String field = fileUpload.name();
            if (!fileMap.containsKey(field)) {
                set = new HashSet();
                fileMap.put(field, set);
            }
            set = (Set)fileMap.get(field);
            set.add((FileUpload)fileUpload);
        });
        return fileMap;
    }

    private static boolean isByteArray(Class<?> expected) {
        if (expected.isArray()) {
            Class<?> componentCls = expected.getComponentType();
            return Byte.TYPE == componentCls || Byte.class == componentCls;
        }
        return false;
    }

    static <T> T toFile(FileUpload fileUpload, Class<?> expected, Function<String, Buffer> consumer) {
        String filename = fileUpload.uploadedFileName();
        if (FileUpload.class.isAssignableFrom(expected)) {
            return (T)fileUpload;
        }
        if (File.class == expected) {
            return (T)ZeroSerializer.getValue(expected, filename);
        }
        if (expected.isArray()) {
            Class<?> componentCls = expected.getComponentType();
            if (Upload.isByteArray(expected)) {
                Buffer buffer = consumer.apply(filename);
                byte[] bytes = buffer.getBytes();
                if (Byte.TYPE == componentCls) {
                    return (T)bytes;
                }
                Byte[] byteWrapper = new Byte[bytes.length];
                for (int idx = 0; idx < bytes.length; ++idx) {
                    byteWrapper[idx] = bytes[idx];
                }
                return (T)byteWrapper;
            }
            LOGGER.warn("The array type support byte[]/Byte[] only in current version, current = {0}", new Object[]{componentCls.getName()});
            return null;
        }
        if (Buffer.class.isAssignableFrom(expected)) {
            return (T)consumer.apply(filename);
        }
        LOGGER.warn("The expected type {0} is not supported.", new Object[]{expected.getName()});
        return null;
    }
}

