/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.tp.plugin.job.JobClient;
import io.vertx.tp.plugin.job.JobInfix;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;

public class UxJob {
    private static final Annal LOGGER = Annal.get(UxJob.class);
    private final transient JobClient client = JobInfix.getClient();

    UxJob() {
    }

    public Future<Boolean> start(String code) {
        return Fn.thenGeneric(future -> this.client.start(code, (Handler<AsyncResult<Long>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} has been started with timeId: {1}.", new Object[]{code, res.result()});
            future.complete((Object)Boolean.TRUE);
        })));
    }

    public Future<Boolean> stop(String code) {
        long timeId = JobPool.timeId(code);
        return Fn.thenGeneric(future -> this.client.stop(timeId, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} has been stopped and timeId: {1} removed.", new Object[]{code, timeId});
            future.complete((Object)Boolean.TRUE);
        })));
    }

    public Future<Boolean> resume(String code) {
        long timeId = JobPool.timeId(code);
        return Fn.thenGeneric(future -> this.client.resume(timeId, (Handler<AsyncResult<Long>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} will be resume and new timeId generated: {1}.", new Object[]{code, timeId});
            future.complete((Object)Boolean.TRUE);
        })));
    }
}

