/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.verticle;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroGrid;
import io.vertx.up.runtime.ZeroHeart;
import io.vertx.up.uca.registry.Uddi;
import io.vertx.up.uca.registry.UddiRegistry;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.DynamicAxis;
import io.vertx.up.uca.rs.router.EventAxis;
import io.vertx.up.uca.rs.router.FilterAxis;
import io.vertx.up.uca.rs.router.RouterAxis;
import io.vertx.up.uca.rs.router.WallAxis;
import io.vertx.up.uca.rs.router.monitor.MeansureAxis;
import io.vertx.up.util.Ut;
import io.vertx.up.verticle.Pool;
import io.vertx.up.verticle.ZeroAtomic;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent
public class ZeroHttpAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpAgent.class);
    private static final ConcurrentMap<Integer, String> SERVICES = ZeroGrid.getServerNames();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread(Pool.ROUTERS, () -> new RouterAxis(this.vertx));
        Axis axiser = (Axis)Fn.poolThread(Pool.EVENTS, EventAxis::new);
        Axis dynamic = (Axis)Fn.poolThread(Pool.DYNAMICS, DynamicAxis::new);
        Axis wallAxiser = (Axis)Fn.poolThread(Pool.WALLS, () -> (Axis)Ut.instance(WallAxis.class, (Object[])new Object[]{this.vertx}));
        Axis filterAxiser = (Axis)Fn.poolThread(Pool.FILTERS, FilterAxis::new);
        Axis monitorAxiser = (Axis)Fn.poolThread(Pool.MEANSURES, () -> new MeansureAxis(this.vertx, false));
        ZeroAtomic.HTTP_OPTS.forEach((port, option) -> {
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount(router);
            wallAxiser.mount(router);
            axiser.mount(router);
            monitorAxiser.mount(router);
            ((DynamicAxis)dynamic).bind(this.vertx).mount(router);
            filterAxiser.mount(router);
            server.requestHandler((Handler)router).listen();
            this.registryServer((HttpServerOptions)option, router);
        });
    }

    public void stop() {
        Ut.itMap(ZeroAtomic.HTTP_OPTS, (port, config) -> {
            if (ZeroHeart.isEtcd()) {
                UddiRegistry registry = Uddi.registry(((Object)((Object)this)).getClass());
                registry.registryHttp((String)SERVICES.get(port), (HttpServerOptions)config, Etat.STOPPED);
            }
        });
    }

    private void registryServer(HttpServerOptions options, Router router) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)ZeroAtomic.HTTP_START_LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("( Http Server ) {0} (id = {1}) Agent has deployed HTTP Server on {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.deploymentID(), portLiteral});
            List routes = router.getRoutes();
            TreeMap<String, Set> routeMap = new TreeMap<String, Set>();
            TreeSet<String> tree = new TreeSet<String>();
            for (Route route : routes) {
                String path2;
                if (null != route.getPath()) {
                    if (!routeMap.containsKey(route.getPath())) {
                        routeMap.put(route.getPath(), new HashSet());
                    }
                    ((Set)routeMap.get(route.getPath())).add(route);
                }
                if ("/*".equals(path2 = null == route.getPath() ? "/*" : route.getPath())) continue;
                tree.add(path2);
            }
            routeMap.forEach((path, routeSet) -> routeSet.forEach(route -> LOGGER.info("( Uri Register ) \"{1}\" has been deployed by {0}, Options = {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), path, route.toString()})));
            String address = MessageFormat.format("http://{0}:{1}/", Ut.netIPv4(), portLiteral);
            LOGGER.info("( Http Server ) {0} Http Server has been started successfully. Endpoint: {1}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), address});
            String name = (String)SERVICES.get(port);
            this.startRegistry(name, options, tree);
        }
    }

    private void startRegistry(String name, HttpServerOptions options, Set<String> tree) {
        if (ZeroHeart.isEtcd()) {
            JsonObject data = this.getMessage(name, options, tree);
            EventBus bus = this.vertx.eventBus();
            String address = "ZERO://MICRO/REGISTRY/START";
            LOGGER.info("---> {2} ( Http Server ) {0} ( name = {1} ) is sending data to internal address.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), name, "ZERO://MICRO/REGISTRY/START"});
            bus.publish("ZERO://MICRO/REGISTRY/START", (Object)data);
        }
    }

    private JsonObject getMessage(String name, HttpServerOptions options, Set<String> tree) {
        JsonObject data = new JsonObject();
        data.put("name", name);
        data.put("options", options.toJson());
        if (null != tree) {
            data.put("uris", Ut.fromJoin(tree));
        }
        return data;
    }
}

