/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.job;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.job.JobClient;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.center.Agha;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JobClientImpl
implements JobClient {
    private static final Annal LOGGER = Annal.get(JobClientImpl.class);
    private final transient Vertx vertx;
    private final transient JsonObject config;

    JobClientImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public Future<Long> startAsync(String code) {
        Mission mission = JobPool.get(code);
        if (Objects.nonNull(mission)) {
            Agha agha = Agha.get(mission.getType());
            Ut.contract((Object)agha, Vertx.class, (Object)this.vertx);
            return agha.begin(mission);
        }
        LOGGER.info("( JobClient ) The pool could not find job of code = `{0}`", new Object[]{code});
        return Ux.future(-1L);
    }

    @Override
    public JobClient startAsync(String code, Handler<AsyncResult<Long>> handler) {
        handler.handle(this.startAsync(code));
        return this;
    }

    @Override
    public Future<Boolean> stopAsync(String code) {
        Long timerId = JobPool.timeId(code);
        JobPool.stop(timerId);
        this.vertx.cancelTimer(timerId.longValue());
        return Future.succeededFuture((Object)Boolean.TRUE);
    }

    @Override
    public JobClient stopAsync(String code, Handler<AsyncResult<Boolean>> handler) {
        handler.handle(this.stopAsync(code));
        return this;
    }

    @Override
    public Future<Long> resumeAsync(String code) {
        Long timeId = JobPool.timeId(code);
        JobPool.resume(timeId);
        return this.startAsync(code);
    }

    @Override
    public JobClient resumeAsync(String code, Handler<AsyncResult<Long>> handler) {
        handler.handle(this.resumeAsync(code));
        return this;
    }

    @Override
    public JobClient fetchAsync(String code, Handler<AsyncResult<Mission>> handler) {
        handler.handle(this.fetchAsync(code));
        return this;
    }

    @Override
    public Future<Mission> fetchAsync(String code) {
        return Future.succeededFuture((Object)this.fetch(code));
    }

    @Override
    public Mission fetch(String code) {
        return JobPool.get(code);
    }

    @Override
    public JobClient fetchAsync(Set<String> codes, Handler<AsyncResult<List<Mission>>> handler) {
        handler.handle(this.fetchAsync(codes));
        return this;
    }

    @Override
    public List<Mission> fetch(Set<String> codes) {
        List<Mission> missionList = JobPool.get();
        if (Objects.isNull(codes) || codes.isEmpty()) {
            return new ArrayList<Mission>();
        }
        return missionList.stream().filter(mission -> codes.contains(mission.getCode())).collect(Collectors.toList());
    }

    @Override
    public Future<List<Mission>> fetchAsync(Set<String> codes) {
        return Ux.future(this.fetch(codes));
    }

    @Override
    public JobClient saveAsync(Mission mission, Handler<AsyncResult<Mission>> handler) {
        handler.handle(this.saveAsync(mission));
        return this;
    }

    @Override
    public Mission save(Mission mission) {
        JobPool.save(mission);
        return mission;
    }

    @Override
    public Future<Mission> saveAsync(Mission mission) {
        return Ux.future(this.save(mission));
    }

    @Override
    public Mission remove(String code) {
        Mission mission = this.fetch(code);
        JobPool.remove(code);
        return mission;
    }

    @Override
    public Future<Mission> removeAsync(String code) {
        return Ux.future(this.remove(code));
    }

    @Override
    public JobClient removeAsync(String code, Handler<AsyncResult<Mission>> handler) {
        handler.handle(this.removeAsync(code));
        return this;
    }

    @Override
    public JobClient saveAsync(Set<Mission> missions, Handler<AsyncResult<Set<Mission>>> handler) {
        handler.handle(this.saveAsync(missions));
        return this;
    }

    @Override
    public Future<Set<Mission>> saveAsync(Set<Mission> missions) {
        return Ux.future(this.save(missions));
    }

    @Override
    public Set<Mission> save(Set<Mission> missions) {
        missions.forEach(this::save);
        return missions;
    }

    @Override
    public JsonObject status(String namespace) {
        return JobPool.status(namespace);
    }

    @Override
    public Future<JsonObject> statusAsync(String namespace) {
        return Ux.future(this.status(namespace));
    }

    @Override
    public JobClient statusAsync(String namespace, Handler<AsyncResult<JsonObject>> handler) {
        handler.handle(this.statusAsync(namespace));
        return this;
    }
}

