/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.job;

import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class JobPool {
    private static final Annal LOGGER = Annal.get(JobPool.class);
    private static final ConcurrentMap<String, Mission> JOBS = new ConcurrentHashMap<String, Mission>();
    private static final ConcurrentMap<Long, String> RUNNING = new ConcurrentHashMap<Long, String>();

    JobPool() {
    }

    static void remove(String code) {
        JOBS.remove(code);
    }

    static void save(Mission mission) {
        if (Objects.nonNull(mission)) {
            JOBS.put(mission.getCode(), mission);
        }
    }

    static void bind(Long timeId, String code) {
        RUNNING.put(timeId, code);
    }

    static List<Mission> get() {
        return JOBS.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    static Mission get(String code) {
        return (Mission)JOBS.get(code);
    }

    static void start(Long timeId, String code) {
        JobPool.uniform(code, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.RUNNING == status) {
                LOGGER.info("( Job ) The job {0} has already been running !!!", new Object[]{code});
            } else if (JobStatus.ERROR == status) {
                LOGGER.warn("( Job ) The job {0} met error last time, please contact administrator and try to resume.", new Object[]{code});
            } else if (JobStatus.STARTING == status) {
                LOGGER.warn("( Job ) The job {0} is booting, please preparing for READY", new Object[]{code});
            } else {
                if (JobStatus.STOPPED == status) {
                    ((Mission)JOBS.get(code)).setStatus(JobStatus.READY);
                }
                RUNNING.put(timeId, code);
            }
        });
    }

    static void stop(Long timeId) {
        JobPool.uniform(timeId, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.RUNNING == status || JobStatus.READY == status) {
                RUNNING.remove(timeId);
                mission.setStatus(JobStatus.STOPPED);
            } else {
                LOGGER.info("( Job ) The job {0} is not running, the status is = {1}", new Object[]{mission.getCode(), status});
            }
        });
    }

    static void resume(Long timeId) {
        JobPool.uniform(timeId, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.ERROR == status) {
                RUNNING.put(timeId, mission.getCode());
                mission.setStatus(JobStatus.READY);
            }
        });
    }

    static JsonObject status(String namespace) {
        ConcurrentHashMap runsRevert = new ConcurrentHashMap();
        RUNNING.forEach((timer, code) -> runsRevert.put(code, timer));
        JsonObject response = new JsonObject();
        JOBS.forEach((code, mission) -> {
            JsonObject instance = new JsonObject();
            instance.put("name", mission.getName());
            instance.put("status", mission.getStatus().name());
            instance.put("timer", (Long)runsRevert.get(mission.getCode()));
            response.put(mission.getCode(), instance);
        });
        return response;
    }

    static String code(Long timeId) {
        return (String)RUNNING.get(timeId);
    }

    static Long timeId(String code) {
        return RUNNING.keySet().stream().filter(key -> code.equals(RUNNING.get(key))).findFirst().orElse(null);
    }

    private static void uniform(Long timeId, Consumer<Mission> consumer) {
        String code = (String)RUNNING.get(timeId);
        if (Ut.isNil((String)code)) {
            LOGGER.info("( Job ) The timeId {0} does not exist in RUNNING pool of jobs.", new Object[]{timeId});
        } else {
            JobPool.uniform(code, consumer);
        }
    }

    private static void uniform(String code, Consumer<Mission> consumer) {
        Mission mission = (Mission)JOBS.get(code);
        if (Objects.nonNull(mission)) {
            consumer.accept(mission);
        }
    }
}

