/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up;

import io.vertx.tp.error.RpcPreparingException;
import io.vertx.up.Launcher;
import io.vertx.up.annotations.Up;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.Anno;
import io.vertx.up.runtime.Runner;
import io.vertx.up.runtime.ZeroHeart;
import io.vertx.up.uca.web.ZeroLauncher;
import io.vertx.up.uca.web.anima.DetectScatter;
import io.vertx.up.uca.web.anima.InfixScatter;
import io.vertx.up.uca.web.anima.PointScatter;
import io.vertx.up.uca.web.anima.Scatter;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.UpClassArgsException;
import io.vertx.zero.exception.UpClassInvalidException;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MicroApplication {
    private static final Annal LOGGER = Annal.get(MicroApplication.class);
    private final transient Class<?> clazz;
    private transient ConcurrentMap<String, Annotation> annotationMap = new ConcurrentHashMap<String, Annotation>();

    private MicroApplication(Class<?> clazz) {
        Fn.outUp((null == clazz ? 1 : 0) != 0, (Annal)LOGGER, UpClassArgsException.class, (Object[])new Object[]{this.getClass()});
        this.clazz = clazz;
        this.annotationMap = Anno.get(clazz);
        Fn.outUp((!this.annotationMap.containsKey(Up.class.getName()) ? 1 : 0) != 0, (Annal)LOGGER, UpClassInvalidException.class, (Object[])new Object[]{this.getClass(), clazz.getName()});
    }

    public static void run(Class<?> clazz, Object ... args) {
        Fn.onRun(() -> new MicroApplication(clazz).run(args), (Annal)LOGGER);
    }

    private void run(Object ... args) {
        Fn.outUp((!ZeroHeart.isEtcd() ? 1 : 0) != 0, (Annal)LOGGER, RpcPreparingException.class, (Object[])new Object[]{this.getClass()});
        Launcher launcher = (Launcher)Ut.singleton(ZeroLauncher.class, (Object[])new Object[0]);
        launcher.start(vertx -> {
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(PointScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"gateway-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(DetectScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"detect-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(InfixScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"infix-afflux-runner");
        });
    }
}

