/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Record;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ActiveRecord
implements Record {
    private final transient JsonObject data = new JsonObject();

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected JsonObject data() {
        return this.data;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean isPersist() {
        return false;
    }

    public boolean isValue(String field) {
        return this.data.containsKey(field);
    }

    public <T> T get(String field) {
        Object value = this.data.getValue(field);
        return (T)value;
    }

    public JsonObject get(String ... fields) {
        JsonObject json = new JsonObject();
        Arrays.stream(fields).forEach(each -> json.put(each, this.data.getValue(each)));
        return json;
    }

    public ConcurrentMap<String, Class<?>> types() {
        return new ConcurrentHashMap();
    }

    public JsonObject get() {
        return this.toJson();
    }

    public <V> Record set(String field, V value) {
        if (this.declaredFields().contains(field)) {
            Class type = (Class)this.types().get(field);
            this.data.put(field, Ut.aiJValue(value, (Class)type));
        } else {
            this.getLogger().debug("The field `{0}` has not been defined in model: `{1}`", new Object[]{field, this.identifier()});
        }
        return this;
    }

    public <V> Record attach(String field, V value) {
        this.data.put(field, value);
        return this;
    }

    public Record set(JsonObject data) {
        if (!Ut.isNil((JsonObject)data)) {
            data.stream().filter(Objects::nonNull).forEach(entry -> this.set((String)entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public <V> Record add(String field, V value) {
        if (null == this.data.getValue(field)) {
            this.set(field, value);
        }
        return this;
    }

    public Record add(JsonObject data) {
        if (Ut.notNil((JsonObject)data)) {
            data.stream().filter(Objects::nonNull).forEach(entry -> this.add((String)entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public Record remove(String field) {
        if (this.data.containsKey(field)) {
            this.data.remove(field);
        }
        return this;
    }

    public Record remove(String ... fields) {
        Arrays.stream(fields).forEach(this::remove);
        return this;
    }

    public Record createSubset(String ... fields) {
        Record record = this.createNew();
        Arrays.stream(fields).forEach(field -> record.set(field, this.get((String)field)));
        return record;
    }

    public Record createCopy() {
        Record record = this.createNew();
        record.set(this.data);
        return record;
    }

    public JsonObject toJson() {
        JsonObject json = this.data.copy();
        this.data.fieldNames().stream().filter(field -> Objects.isNull(json.getValue(field))).forEach(arg_0 -> ((JsonObject)json).remove(arg_0));
        return json;
    }

    public void fromJson(JsonObject json) {
        if (Ut.notNil((JsonObject)json)) {
            this.data.mergeIn(json);
        }
    }

    public int size() {
        return this.data.size();
    }

    public Set<String> fields() {
        return this.data.fieldNames();
    }

    public Set<String> joins() {
        return new HashSet<String>();
    }
}

