/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime;

import io.vertx.core.ClusterOptions;
import io.vertx.core.ServidorOptions;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAmbient;
import io.vertx.up.uca.options.HttpServerVisitor;
import io.vertx.up.uca.options.NamesVisitor;
import io.vertx.up.uca.options.NodeVisitor;
import io.vertx.up.uca.options.RpcServerVisitor;
import io.vertx.up.uca.options.RxServerVisitor;
import io.vertx.up.uca.options.ServerVisitor;
import io.vertx.up.uca.options.SockServerVisitor;
import io.vertx.up.uca.options.VertxVisitor;
import io.vertx.up.util.Ut;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ZeroGrid {
    private static final Annal LOGGER = Annal.get(ZeroGrid.class);
    private static final ConcurrentMap<String, VertxOptions> VX_OPTS = new ConcurrentHashMap<String, VertxOptions>();
    private static final ConcurrentMap<Integer, HttpServerOptions> SERVER_OPTS = new ConcurrentHashMap<Integer, HttpServerOptions>();
    private static final ConcurrentMap<Integer, String> SERVER_NAMES = new ConcurrentHashMap<Integer, String>();
    private static final ConcurrentMap<Integer, ServidorOptions> RPC_OPTS = new ConcurrentHashMap<Integer, ServidorOptions>();
    private static final ConcurrentMap<Integer, HttpServerOptions> RX_OPTS = new ConcurrentHashMap<Integer, HttpServerOptions>();
    private static final ConcurrentMap<Integer, HttpServerOptions> SOCK_OPTS = new ConcurrentHashMap<Integer, HttpServerOptions>();
    private static ClusterOptions CLUSTER;

    public static ConcurrentMap<String, VertxOptions> getVertxOptions() {
        return VX_OPTS;
    }

    public static ConcurrentMap<Integer, HttpServerOptions> getServerOptions() {
        return SERVER_OPTS;
    }

    public static ConcurrentMap<Integer, String> getServerNames() {
        return SERVER_NAMES;
    }

    public static ConcurrentMap<Integer, HttpServerOptions> getRxOptions() {
        return RX_OPTS;
    }

    public static ConcurrentMap<Integer, ServidorOptions> getRpcOptions() {
        return RPC_OPTS;
    }

    public static ConcurrentMap<Integer, HttpServerOptions> getSockOptions() {
        return SOCK_OPTS;
    }

    public static ClusterOptions getClusterOption() {
        return CLUSTER;
    }

    static {
        Fn.outUp(() -> {
            NodeVisitor visitor;
            if (VX_OPTS.isEmpty() || null == CLUSTER) {
                visitor = (NodeVisitor)Ut.singleton(VertxVisitor.class, (Object[])new Object[0]);
                VX_OPTS.putAll((Map)visitor.visit(new String[0]));
                CLUSTER = visitor.getCluster();
            }
            if (SERVER_OPTS.isEmpty()) {
                visitor = (ServerVisitor)Ut.singleton(HttpServerVisitor.class, (Object[])new Object[0]);
                SERVER_OPTS.putAll((Map)visitor.visit(new String[0]));
                if (SERVER_NAMES.isEmpty()) {
                    ServerVisitor VISITOR = (ServerVisitor)Ut.singleton(NamesVisitor.class, (Object[])new Object[0]);
                    SERVER_NAMES.putAll((Map)VISITOR.visit(new String[]{ServerType.HTTP.toString()}));
                }
            }
            if (RX_OPTS.isEmpty()) {
                visitor = (ServerVisitor)Ut.singleton(RxServerVisitor.class, (Object[])new Object[0]);
                RX_OPTS.putAll((Map)visitor.visit(new String[0]));
            }
            if (RPC_OPTS.isEmpty()) {
                visitor = (ServerVisitor)Ut.singleton(RpcServerVisitor.class, (Object[])new Object[0]);
                RPC_OPTS.putAll((Map)visitor.visit(new String[0]));
            }
            if (SOCK_OPTS.isEmpty()) {
                visitor = (ServerVisitor)Ut.singleton(SockServerVisitor.class, (Object[])new Object[0]);
                SOCK_OPTS.putAll((Map)visitor.visit(new String[0]));
            }
            ZeroAmbient.init();
        }, (Annal)LOGGER);
    }
}

