/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime;

import io.vertx.core.http.HttpMethod;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.matcher.RegexPath;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

class ZeroUri {
    private static final Annal LOGGER = Annal.get(ZeroUri.class);
    private static final ConcurrentMap<HttpMethod, Set<String>> URIS = new ConcurrentHashMap<HttpMethod, Set<String>>(){
        {
            this.put(HttpMethod.GET, new HashSet());
            this.put(HttpMethod.POST, new HashSet());
            this.put(HttpMethod.DELETE, new HashSet());
            this.put(HttpMethod.PUT, new HashSet());
        }
    };

    ZeroUri() {
    }

    static void resolve(Event event) {
        ZeroUri.resolve(event.getMethod(), event.getPath());
    }

    static void resolve(HttpMethod method, String uri) {
        if (Objects.isNull(method)) {
            URIS.keySet().forEach(each -> ZeroUri.addSingle(each, uri));
        } else {
            ZeroUri.addSingle(method, uri);
        }
    }

    static boolean isMatch(HttpMethod method, String requestUri) {
        return ((Set)URIS.get(method)).stream().anyMatch(uri -> ZeroUri.isMatch(requestUri, uri));
    }

    static void report() {
        long size = URIS.values().stream().mapToLong(Set::size).sum();
        LOGGER.info("( Uri ) Pattern Uri Size: {0}", new Object[]{String.valueOf(size)});
    }

    static String recovery(String uri, HttpMethod method) {
        Set definition = (Set)URIS.get(method);
        if (Objects.isNull(definition)) {
            return uri;
        }
        return definition.stream().filter(path -> ZeroUri.isMatch(uri, path)).findFirst().orElse(uri);
    }

    private static boolean isMatch(String uri, String path) {
        Pattern pattern = RegexPath.createRegex(path);
        return pattern.matcher(uri).matches();
    }

    private static void addSingle(HttpMethod method, String uri) {
        ((Set)URIS.get(method)).add(uri);
    }
}

