/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._400BadRequestException;
import io.vertx.up.exception.web._401UnauthorizedException;
import io.vertx.up.exception.web._403ForbiddenException;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.handler.AuthReady;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AuthPhylum
implements AuthHandler {
    static final String AUTH_PROVIDER_CONTEXT_KEY = "io.vertx.ext.web.handler.AuthHandler.provider";
    protected final String realm;
    protected final Set<String> authorities = new HashSet<String>();
    final WebException FORBIDDEN = new _403ForbiddenException(this.getClass());
    final WebException UNAUTHORIZED = new _401UnauthorizedException(this.getClass());
    final WebException BAD_REQUEST = new _400BadRequestException(this.getClass());
    protected transient AuthProvider authProvider;

    public AuthPhylum(AuthProvider authProvider) {
        this(authProvider, "");
    }

    public AuthPhylum(AuthProvider authProvider, String realm) {
        this.authProvider = authProvider;
        this.realm = realm;
    }

    public AuthHandler addAuthority(String authority) {
        this.authorities.add(authority);
        return this;
    }

    public AuthHandler addAuthorities(Set<String> authorities) {
        this.authorities.addAll(authorities);
        return this;
    }

    protected String authenticateHeader(RoutingContext context) {
        return null;
    }

    public void authorize(User user, Handler<AsyncResult<Void>> handler) {
        int requiredcount = this.authorities.size();
        if (requiredcount > 0) {
            if (user == null) {
                handler.handle((Object)Future.failedFuture((Throwable)this.FORBIDDEN));
                return;
            }
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean sentFailure = new AtomicBoolean();
            Handler authHandler = res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (count.incrementAndGet() == requiredcount) {
                            handler.handle((Object)Future.succeededFuture());
                        }
                    } else if (sentFailure.compareAndSet(false, true)) {
                        handler.handle((Object)Future.failedFuture((Throwable)this.FORBIDDEN));
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                }
            };
            for (String authority : this.authorities) {
                if (sentFailure.get()) continue;
                user.isAuthorized(authority, authHandler);
            }
        } else {
            handler.handle((Object)Future.succeededFuture());
        }
    }

    public void handle(RoutingContext ctx) {
        if (this.handlePreflight(ctx)) {
            return;
        }
        User user = ctx.user();
        if (user != null) {
            this.authorizeUser(ctx, user);
            return;
        }
        this.parseCredentials(ctx, res -> {
            if (res.failed()) {
                this.processException(ctx, res.cause());
                return;
            }
            User updatedUser = ctx.user();
            if (updatedUser != null) {
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                }
                this.authorizeUser(ctx, updatedUser);
                return;
            }
            JsonObject readyForAuthorized = AuthReady.prepare((JsonObject)res.result(), ctx);
            this.getAuthProvider(ctx).authenticate(readyForAuthorized, authN -> {
                if (authN.succeeded()) {
                    User authenticated = (User)authN.result();
                    ctx.setUser(authenticated);
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                    }
                    this.authorizeUser(ctx, authenticated);
                } else {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    ctx.fail((Throwable)(null == authN.cause() ? this.UNAUTHORIZED : authN.cause()));
                }
            });
        });
    }

    private void processException(RoutingContext ctx, Throwable exception) {
        if (null != exception && exception instanceof WebException) {
            WebException error = (WebException)exception;
            HttpStatusCode statusCode = error.getStatus();
            String payload = error.getMessage();
            HttpServerResponse response = ctx.response();
            switch (statusCode) {
                case MOVE_TEMPORARILY: {
                    response.putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(statusCode.code()).end("Redirecting to " + payload + ".");
                    return;
                }
                case UNAUTHORIZED: {
                    String header = this.authenticateHeader(ctx);
                    if (null != header) {
                        response.putHeader("WWW-Authenticate", header);
                    }
                    ctx.fail((Throwable)this.UNAUTHORIZED);
                    return;
                }
            }
            ctx.fail((Throwable)error);
            return;
        }
        ctx.fail((Throwable)((Object)new _500InternalServerException(this.getClass(), null == exception ? null : exception.getMessage())));
    }

    private void authorizeUser(RoutingContext ctx, User user) {
        JsonObject readyForAuthorized = AuthReady.prepare(user.principal(), ctx);
        this.authProvider.authenticate(readyForAuthorized, processed -> {
            if (processed.succeeded()) {
                this.authorize((User)processed.result(), (Handler<AsyncResult<Void>>)((Handler)authZ -> {
                    if (authZ.failed()) {
                        this.processException(ctx, authZ.cause());
                        return;
                    }
                    ctx.next();
                }));
            } else {
                Throwable ex = processed.cause();
                if (Objects.nonNull(ex)) {
                    ctx.fail(ex);
                } else {
                    ctx.fail((Throwable)this.FORBIDDEN);
                }
            }
        });
    }

    private boolean handlePreflight(RoutingContext ctx) {
        String accessControlRequestHeader;
        HttpServerRequest request = ctx.request();
        if (request.method() == HttpMethod.OPTIONS && (accessControlRequestHeader = ctx.request().getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            for (String ctrlReq : accessControlRequestHeader.split(",")) {
                if (!ctrlReq.equalsIgnoreCase(HttpHeaders.AUTHORIZATION.toString())) continue;
                ctx.next();
                return true;
            }
        }
        return false;
    }

    private AuthProvider getAuthProvider(RoutingContext ctx) {
        try {
            AuthProvider provider = (AuthProvider)ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
            if (provider != null) {
                this.authProvider = provider;
                return provider;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return this.authProvider;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

