/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.provider;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._401JwtExecutorException;
import io.vertx.up.exception.web._403ForbiddenException;
import io.vertx.up.secure.Security;
import io.vertx.up.unity.Ux;
import java.util.function.Supplier;

class JwtSecurer {
    private transient Security security;
    private transient String permissionsClaimKey;

    private JwtSecurer() {
    }

    static JwtSecurer create() {
        return new JwtSecurer();
    }

    void setSecurity(Security security) {
        this.security = security;
    }

    void setPermissionsClaimKey(String permissionsClaimKey) {
        this.permissionsClaimKey = permissionsClaimKey;
    }

    Future<User> authenticate(JsonObject authInfo) {
        String token = authInfo.getString("jwt");
        return this.security.verify(authInfo).compose(authenticated -> this.next((boolean)authenticated, () -> this.authorize(authInfo), () -> new _401JwtExecutorException(this.getClass(), token)));
    }

    Future<User> authorize(JsonObject authInfo) {
        return this.security.access(authInfo).compose(authorized -> this.next((boolean)authorized, () -> Ux.future(new JWTUser(authInfo, this.permissionsClaimKey)), () -> new _403ForbiddenException(this.getClass())));
    }

    private Future<User> next(boolean checked, Supplier<Future<User>> success, Supplier<WebException> error) {
        if (checked) {
            Future future = success.get();
            Throwable failure = future.cause();
            return null == failure ? future : Future.failedFuture((Throwable)failure);
        }
        return Future.failedFuture((Throwable)((Throwable)error.get()));
    }
}

