/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cosmic;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.config.IntegrationRequest;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cosmic.AbstractEmitter;
import io.vertx.up.util.Ut;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.MediaType;

class LegacyEmitter
extends AbstractEmitter {
    LegacyEmitter(Integration integration) {
        super(integration);
    }

    @Override
    protected void initialize() {
        SSLContext context = this.sslContext();
        if (Objects.nonNull(context)) {
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
    }

    @Override
    public String request(String apiKey, JsonObject params, MultiMap headers) {
        return (String)Fn.getNull((Object)"", () -> {
            IntegrationRequest request = this.integration().createRequest(apiKey);
            String content = Ut.encryptRSA((String)params.encode(), (String)this.integration().getPublicKeyFile());
            return this.send(request.getPath(), request.getMethod(), MediaType.APPLICATION_JSON_TYPE, content);
        }, (Object[])new Object[]{params, apiKey});
    }

    private String send(String uri, HttpMethod method, MediaType mediaType, String content) {
        return (String)Fn.getJvm(null, () -> {
            this.logger().info("Http request: uri = {0}, method = {1}, data = {2}", new Object[]{uri, method, content});
            String contentType = Objects.isNull(mediaType) ? "application/json" : mediaType.toString();
            this.initialize();
            URL url = new URL(uri);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.name());
            conn.setRequestProperty("Content-Type", contentType);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            PrintWriter out = new PrintWriter(conn.getOutputStream());
            out.print(content);
            out.flush();
            out.close();
            String response = Ut.ioString((InputStream)conn.getInputStream());
            String normalized = new String(response.getBytes(), "UTF-8");
            this.logger().info("Http response: data = {0}", new Object[]{normalized});
            return normalized;
        }, (Object[])new Object[]{uri, method, content});
    }
}

