/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.di;

import io.reactivex.Observable;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.Infix;
import io.vertx.up.runtime.ZeroAmbient;
import io.vertx.up.uca.di.Pool;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DiPlugin {
    private final transient Class<?> clazz;
    private final transient Annal logger;

    private DiPlugin(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = Annal.get(clazz);
    }

    public static DiPlugin create(Class<?> clazz) {
        return (DiPlugin)Fn.pool(Pool.PLUGINS, clazz, () -> new DiPlugin(clazz));
    }

    public void inject(Object proxy) {
        ConcurrentMap<Class<?>, Class<?>> binds = this.getBind();
        Class<?> type = proxy.getClass();
        Observable.fromArray((Object[])type.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Plugin.class)).subscribe(field -> {
            Class<?> fieldType = field.getType();
            Class infixCls = (Class)binds.get(fieldType);
            if (null != infixCls) {
                if (Ut.isImplement((Class)infixCls, Infix.class)) {
                    Infix reference = (Infix)Ut.singleton((Class)infixCls, (Object[])new Object[0]);
                    Object tpRef = Ut.invoke((Object)reference, (String)"get", (Object[])new Object[0]);
                    String fieldName = field.getName();
                    Ut.field((Object)proxy, (String)fieldName, (Object)tpRef);
                } else {
                    this.logger.warn("The hitted class {0} does not implement the interfaceof {1}", new Object[]{infixCls.getName(), Infix.class.getName()});
                }
            } else {
                this.logger.warn("The system scanned null infix for key = {0} on the field \"{1}\" of {2}", new Object[]{field.getType().getName(), field.getName(), type.getName()});
            }
        }).dispose();
    }

    private ConcurrentMap<Class<?>, Class<?>> getBind() {
        HashSet infixes = new HashSet(ZeroAmbient.getInjections().values());
        ConcurrentHashMap binds = new ConcurrentHashMap();
        Observable.fromIterable(infixes).filter(Infix.class::isAssignableFrom).subscribe(item -> {
            Method method = (Method)Fn.getJvm(() -> item.getDeclaredMethod("get", new Class[0]), (Object[])new Object[]{item});
            Class<?> type = method.getReturnType();
            binds.put(type, (Class<?>)item);
        }).dispose();
        return binds;
    }
}

