/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.store;

import io.vertx.up.atom.worker.Mission;
import io.vertx.up.uca.job.store.JobConfig;
import io.vertx.up.uca.job.store.JobPin;
import io.vertx.up.uca.job.store.JobStore;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

class ExtensionStore
implements JobStore {
    private static final JobConfig CONFIG = JobPin.getConfig();
    private transient JobStore reference;
    private transient boolean isExtension;

    ExtensionStore() {
        if (Objects.nonNull(CONFIG)) {
            Class storeCls = CONFIG.getStore().getComponent();
            Optional.ofNullable(storeCls).ifPresent(clazz -> {
                this.reference = (JobStore)Ut.instance((Class)clazz, (Object[])new Object[0]);
                if (Objects.nonNull(this.reference)) {
                    this.isExtension = true;
                }
            });
        }
    }

    @Override
    public Set<Mission> fetch() {
        return this.extensionCall(HashSet::new, () -> this.reference.fetch());
    }

    @Override
    public Mission fetch(String name) {
        return this.extensionCall(() -> null, () -> this.reference.fetch(name));
    }

    @Override
    public JobStore remove(Mission mission) {
        if (this.isExtension) {
            this.reference.remove(mission);
        }
        return this;
    }

    @Override
    public JobStore update(Mission mission) {
        if (this.isExtension) {
            this.reference.update(mission);
        }
        return this;
    }

    @Override
    public JobStore add(Mission mission) {
        if (this.isExtension) {
            this.reference.add(mission);
        }
        return this;
    }

    private <T> T extensionCall(Supplier<T> defaultSupplier, Supplier<T> extension) {
        if (this.isExtension) {
            return extension.get();
        }
        return defaultSupplier.get();
    }
}

