/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;

abstract class AbstractAggregator
extends AbstractAction {
    protected AbstractAggregator(JqAnalyzer analyzer) {
        super(analyzer);
    }

    protected JsonArray aggregateBy(Field aggrField, JsonObject criteria, String ... groupFields) {
        List<Map<String, Object>> groupResult = this.fetchAggregation(criteria, new Field[]{aggrField}, groupFields);
        JsonArray result = new JsonArray();
        groupResult.forEach(record -> {
            JsonObject json = new JsonObject();
            Arrays.stream(groupFields).forEach(field -> {
                Field hitColumn = this.analyzer.column((String)field);
                String columnName = hitColumn.getName();
                json.put(field, record.get(columnName));
            });
            String tColumn = aggrField.getName();
            json.put(tColumn.toLowerCase(Locale.getDefault()), record.get(tColumn));
            result.add(json);
        });
        return result;
    }

    protected <T> ConcurrentMap<String, T> aggregateBy(Field aggrField, JsonObject criteria, String groupField) {
        List<Map<String, Object>> groupResult = this.fetchAggregation(criteria, new Field[]{aggrField}, groupField);
        ConcurrentHashMap result = new ConcurrentHashMap();
        Field hitField = this.analyzer.column(groupField);
        String metaKey = hitField.getName();
        groupResult.forEach(record -> {
            Object key = record.get(metaKey);
            Object value = record.get(aggrField.getName());
            if (Objects.nonNull(key) && Objects.nonNull(value)) {
                result.put(key.toString(), value);
            }
        });
        return result;
    }

    protected <T> JsonArray aggregateBy(String fieldName, JsonObject criteria, Function<Field, Field> aggrFun, String ... groupFields) {
        return this.aggregateBy(fieldName, new JsonArray(), (Field field) -> {
            Field aggrField = (Field)aggrFun.apply((Field)field);
            return this.aggregateBy(aggrField, criteria, groupFields);
        });
    }

    protected <T> ConcurrentMap<String, T> aggregateBy(String fieldName, JsonObject criteria, Function<Field, Field> aggrFun, String groupField) {
        return this.aggregateBy(fieldName, new ConcurrentHashMap(), (Field field) -> {
            Field aggrField = (Field)aggrFun.apply((Field)field);
            return this.aggregateBy(aggrField, criteria, groupField);
        });
    }

    protected <T> T aggregateBy(String fieldName, JsonObject criteria, Function<Field, Field> aggrFun, T defaultValue) {
        return (T)this.aggregateBy(fieldName, defaultValue, (Field field) -> {
            Field procField = (Field)aggrFun.apply((Field)field);
            return this.fetchAggregation(criteria, procField);
        });
    }

    private <T> T aggregateBy(String fieldName, T defaultValue, Function<Field, T> function) {
        Field aggrField = this.analyzer.column(fieldName);
        if (Objects.isNull(aggrField)) {
            return defaultValue;
        }
        return function.apply(aggrField);
    }

    private <T> List<Map<String, Object>> fetchAggregation(JsonObject criteria, Field[] selectedFields, String ... groupFields) {
        List groupResult;
        Field[] columns = this.analyzer.column(groupFields);
        DSLContext context = JooqInfix.getDSL();
        ArrayList<Field> selectedList = new ArrayList<Field>();
        selectedList.addAll(Arrays.asList(columns));
        selectedList.addAll(Arrays.asList(selectedFields));
        SelectJoinStep selected = context.select((SelectField[])selectedList.toArray(new Field[0])).from((TableLike)this.vertxDAO.getTable());
        if (0 == columns.length) {
            if (Ut.isNil((JsonObject)criteria)) {
                groupResult = selected.fetchMaps();
            } else {
                Condition[] conditionArray = new Condition[1];
                conditionArray[0] = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
                groupResult = selected.where(conditionArray).fetchMaps();
            }
        } else if (Ut.isNil((JsonObject)criteria)) {
            groupResult = selected.groupBy((GroupField[])columns).fetchMaps();
        } else {
            Condition[] conditionArray = new Condition[1];
            conditionArray[0] = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
            groupResult = selected.where(conditionArray).groupBy((GroupField[])columns).fetchMaps();
        }
        return groupResult;
    }

    private <T> T fetchAggregation(JsonObject criteria, Field aggrField) {
        List<Map<String, Object>> fetched = this.fetchAggregation(criteria, new Field[]{aggrField}, new String[0]);
        if (1 == fetched.size()) {
            Map<String, Object> result = fetched.get(0);
            return (T)result.get(aggrField.getName());
        }
        return null;
    }
}

