/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.util.JqOut;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;
import org.jooq.SelectWithTiesAfterOffsetStep;

public class ActionQr
extends AbstractAction {
    public ActionQr(JqAnalyzer analyzer) {
        super(analyzer);
    }

    <T> Future<List<T>> searchAsync(Qr qr) {
        Function<DSLContext, List> executor = context -> this.searchInternal((DSLContext)context, qr);
        return this.successed(this.vertxDAO.executeAsync(executor));
    }

    <T> Future<List<T>> searchAsync(JsonObject criteria) {
        Function<DSLContext, List> executor = context -> this.searchInternal((DSLContext)context, criteria);
        return this.successed(this.vertxDAO.executeAsync(executor));
    }

    <T> List<T> search(Qr qr) {
        return this.searchInternal(this.context(), qr);
    }

    <T> List<T> search(JsonObject criteria) {
        return this.searchInternal(this.context(), criteria);
    }

    public <T> List<Object> searchPrimary(JsonObject criteria) {
        List<T> entities = this.search(criteria);
        return this.analyzer.primaryValue(entities);
    }

    private <T> List<T> searchInternal(DSLContext context, JsonObject criteria) {
        SelectWhereStep started = context.selectFrom(this.vertxDAO.getTable());
        SelectConditionStep conditionStep = null;
        if (null != criteria) {
            Condition condition = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
            conditionStep = started.where(new Condition[]{condition});
        }
        return started.fetch(this.vertxDAO.mapper());
    }

    private <T> List<T> searchInternal(DSLContext context, Qr qr) {
        Set projectionSet;
        JsonArray projection;
        SelectWhereStep started = context.selectFrom(this.vertxDAO.getTable());
        SelectConditionStep conditionStep = null;
        if (null != qr.getCriteria()) {
            JsonObject criteria = qr.getCriteria().toJson();
            Condition condition = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
            conditionStep = started.where(new Condition[]{condition});
        }
        SelectSeekStepN selectStep = null;
        if (null != qr.getSorter()) {
            List orders = JooqCond.orderBy((Sorter)qr.getSorter(), this.analyzer::column, null);
            selectStep = null == conditionStep ? started.orderBy((Collection)orders) : conditionStep.orderBy((Collection)orders);
        }
        SelectWithTiesAfterOffsetStep pagerStep = null;
        if (null != qr.getPager()) {
            Pager pager = qr.getPager();
            pagerStep = null == selectStep && null == conditionStep ? started.offset(pager.getStart()).limit(pager.getSize()) : (null == selectStep ? conditionStep.offset(pager.getStart()).limit(pager.getSize()) : selectStep.offset(pager.getStart()).limit(pager.getSize()));
        }
        JsonArray jsonArray = projection = Objects.isNull(projectionSet = qr.getProjection()) ? new JsonArray() : Ut.toJArray((Set)projectionSet);
        if (null != pagerStep) {
            return JqOut.toResult(pagerStep.fetch(this.vertxDAO.mapper()), projection, this.analyzer);
        }
        if (null != selectStep) {
            return JqOut.toResult(selectStep.fetch(this.vertxDAO.mapper()), projection, this.analyzer);
        }
        if (null != conditionStep) {
            return JqOut.toResult(conditionStep.fetch(this.vertxDAO.mapper()), projection, this.analyzer);
        }
        return JqOut.toResult(started.fetch(this.vertxDAO.mapper()), projection, this.analyzer);
    }
}

