/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.AbstractAggregator;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.impl.DSL;

class AggregatorCount
extends AbstractAggregator {
    private static final String FIELD_COUNT = "COUNT";

    AggregatorCount(JqAnalyzer analyzer) {
        super(analyzer);
    }

    Long count() {
        return this.vertxDAO.count();
    }

    Future<Long> countAsync() {
        return this.successed(this.vertxDAO.countAsync());
    }

    Long count(JsonObject criteria) {
        return this.countInternal(this.context(), criteria);
    }

    <T> Future<Long> countAsync(JsonObject criteria) {
        Function<DSLContext, Long> executor = context -> this.countInternal((DSLContext)context, criteria);
        return this.successed(this.vertxDAO.executeAsync(executor));
    }

    ConcurrentMap<String, Integer> countBy(JsonObject criteria, String groupField) {
        Field countField = DSL.field((String)"*").count().as(FIELD_COUNT);
        return this.aggregateBy(countField, criteria, groupField);
    }

    JsonArray countBy(JsonObject criteria, String ... groupFields) {
        Field countField = DSL.field((String)"*").count().as(FIELD_COUNT);
        return this.aggregateBy(countField, criteria, groupFields);
    }

    private long countInternal(DSLContext context, JsonObject criteria) {
        Condition condition = this.condition(criteria);
        if (Objects.isNull(condition)) {
            return context.fetchCount(this.vertxDAO.getTable());
        }
        return context.fetchCount(this.vertxDAO.getTable(), condition);
    }
}

