/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.ActionCheck;
import io.vertx.up.uca.jooq.ActionFetch;
import io.vertx.up.uca.jooq.ActionSearch;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.util.JqFlow;
import java.util.List;

class JqReader {
    private transient ActionSearch search;
    private transient ActionFetch fetch;
    private transient ActionCheck check;

    private JqReader(JqAnalyzer analyzer) {
        this.search = new ActionSearch(analyzer);
        this.fetch = new ActionFetch(analyzer);
        this.check = new ActionCheck(analyzer);
    }

    static JqReader create(JqAnalyzer analyzer) {
        return new JqReader(analyzer);
    }

    <T> Future<JsonObject> searchAsync(JsonObject params, JqFlow workflow) {
        return this.search.searchAsync(params, workflow);
    }

    <T> JsonObject search(JsonObject params, JqFlow workflow) {
        return this.search.search(params, workflow);
    }

    <T> Future<List<T>> fetchAllAsync() {
        return this.fetch.fetchAllAsync();
    }

    <T> List<T> fetchAll() {
        return this.fetch.fetchAll();
    }

    <T> Future<List<T>> fetchAsync(String field, Object value) {
        return this.fetch.fetchAsync(field, value);
    }

    <T> List<T> fetch(String field, Object value) {
        return this.fetch.fetch(field, value);
    }

    <T> Future<List<T>> fetchAsync(JsonObject criteria) {
        return this.fetch.fetchAsync(criteria);
    }

    <T> List<T> fetch(JsonObject criteria) {
        return this.fetch.fetch(criteria);
    }

    <T, ID> Future<T> fetchByIdAsync(ID id) {
        return this.fetch.fetchByIdAsync(id);
    }

    <T, ID> T fetchById(ID id) {
        return this.fetch.fetchById(id);
    }

    <T> Future<T> fetchOneAsync(String field, Object value) {
        return this.fetch.fetchOneAsync(field, value);
    }

    <T> T fetchOne(String field, Object value) {
        return this.fetch.fetchOne(field, value);
    }

    <T> Future<T> fetchOneAsync(JsonObject criteria) {
        return this.fetch.fetchOneAsync(criteria);
    }

    <T> T fetchOne(JsonObject criteria) {
        return this.fetch.fetchOne(criteria);
    }

    Future<Boolean> existByIdAsync(Object id) {
        return this.check.existByIdAsync(id);
    }

    Boolean existById(Object id) {
        return this.check.existById(id);
    }

    Future<Boolean> existAsync(JsonObject criteria) {
        return this.check.existAsync(criteria);
    }

    Boolean exist(JsonObject criteria) {
        return this.check.exist(criteria);
    }
}

