/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.ActionDelete;
import io.vertx.up.uca.jooq.ActionInsert;
import io.vertx.up.uca.jooq.ActionUpdate;
import io.vertx.up.uca.jooq.ActionUpsert;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;

class JqWriter {
    private transient ActionInsert insert;
    private transient ActionUpdate update;
    private transient ActionUpsert upsert;
    private transient ActionDelete delete;

    private JqWriter(JqAnalyzer analyzer) {
        this.insert = new ActionInsert(analyzer);
        this.update = new ActionUpdate(analyzer);
        this.upsert = new ActionUpsert(analyzer);
        this.delete = new ActionDelete(analyzer);
    }

    static JqWriter create(JqAnalyzer analyzer) {
        return new JqWriter(analyzer);
    }

    <T> Future<T> insertAsync(T entity) {
        return this.insert.insertAsync(entity);
    }

    <T> Future<List<T>> insertAsync(List<T> entities) {
        return this.insert.insertAsync(entities);
    }

    <T> T insert(T entity) {
        return this.insert.insert(entity);
    }

    <T> List<T> insert(List<T> entities) {
        return this.insert.insert(entities);
    }

    <T> Future<T> updateAsync(T entity) {
        return this.update.updateAsync(entity);
    }

    <T> T update(T entity) {
        return this.update.update(entity);
    }

    <T, ID> T update(ID id, T updated) {
        return this.update.update(id, updated);
    }

    <T, ID> Future<T> updateAsync(ID id, T updated) {
        return this.update.updateAsync(id, updated);
    }

    <T> T update(JsonObject criteria, T updated) {
        return this.update.update(criteria, updated);
    }

    <T> Future<T> updateAsync(JsonObject criteria, T updated) {
        return this.update.updateAsync(criteria, updated);
    }

    <T> Future<List<T>> updateAsync(List<T> entities) {
        return this.update.updateAsync(entities);
    }

    <T> List<T> update(List<T> entities) {
        return this.update.update(entities);
    }

    <T> Future<T> deleteAsync(T entity) {
        return this.delete.deleteAsync(entity);
    }

    <T> Future<List<T>> deleteAsync(List<T> entity) {
        return this.delete.deleteAsync(entity);
    }

    <T> T delete(T entity) {
        return this.delete.delete(entity);
    }

    <T> List<T> delete(List<T> entity) {
        return this.delete.delete(entity);
    }

    <ID> Future<Boolean> deleteByIdAsync(Collection<ID> ids) {
        return this.delete.deleteByIdAsync(ids);
    }

    <ID> Boolean deleteById(Collection<ID> ids) {
        return this.delete.deleteById(ids);
    }

    <T, ID> Boolean deleteBy(JsonObject criteria) {
        return this.delete.deleteBy(criteria);
    }

    <T, ID> Future<Boolean> deleteByAsync(JsonObject criteria) {
        return this.delete.deleteByAsync(criteria);
    }

    public <T> Future<T> upsertAsync(JsonObject criteria, T updated) {
        return this.upsert.upsertAsync(criteria, updated);
    }

    public <T, ID> Future<T> upsertAsync(ID id, T updated) {
        return this.upsert.upsertAsync(id, updated);
    }

    public <T> T upsert(JsonObject criteria, T updated) {
        return this.upsert.upsert(criteria, updated);
    }

    public <T, ID> T upsert(ID id, T updated) {
        return this.upsert.upsert(id, updated);
    }

    <T> List<T> upsert(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.upsert.upsert(criteria, list, finder);
    }

    <T> Future<List<T>> upsertAsync(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.upsert.upsertAsync(criteria, list, finder);
    }
}

