/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.JqJoinder;
import io.vertx.up.uca.jooq.util.JqTool;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class UxJoin {
    private final transient JsonObject configuration = new JsonObject();
    private final transient JqJoinder joinder = new JqJoinder();
    private final transient ConcurrentMap<Class<?>, String> POJO_MAP = new ConcurrentHashMap();
    private transient Mojo merged = null;

    public UxJoin(String file) {
        JsonObject config;
        if (Ut.notNil((String)file) && Ut.notNil((JsonObject)(config = Ut.ioJObject((String)file)))) {
            this.configuration.mergeIn(config);
        }
    }

    public <T> UxJoin add(Class<?> daoCls) {
        this.joinder.add(daoCls, this.translate(daoCls, "key"));
        return this;
    }

    public <T> UxJoin add(Class<?> daoCls, String field) {
        this.joinder.add(daoCls, this.translate(daoCls, field));
        return this;
    }

    public <T> UxJoin pojo(Class<?> daoCls, String pojo) {
        Mojo created = Mirror.create(UxJoin.class).mount(pojo).mojo();
        this.POJO_MAP.put(daoCls, pojo);
        if (Objects.isNull(this.merged)) {
            this.merged = new Mojo();
        }
        this.merged.bind(created).bindColumn(created.getInColumn());
        return this;
    }

    public <T> UxJoin join(Class<?> daoCls) {
        this.joinder.join(daoCls, this.translate(daoCls, "key"));
        return this;
    }

    public <T> UxJoin join(Class<?> daoCls, String field) {
        this.joinder.join(daoCls, this.translate(daoCls, field));
        return this;
    }

    private String translate(Class<?> daoCls, String field) {
        String pojoFile = (String)this.POJO_MAP.get(daoCls);
        if (Ut.isNil((String)pojoFile)) {
            return field;
        }
        Mojo mojo = Mirror.create(UxJoin.class).mount(pojoFile).mojo();
        if (Objects.isNull(mojo)) {
            return field;
        }
        String translated = (String)mojo.getIn().get(field);
        if (Ut.isNil((String)translated)) {
            return field;
        }
        return translated;
    }

    public Future<JsonObject> searchAsync(JsonObject params) {
        return this.searchAsync(this.toQr(params));
    }

    private Qr toQr(JsonObject params) {
        return Objects.isNull(this.merged) ? Qr.create((JsonObject)params) : JqTool.qr(params, this.merged);
    }

    public Future<JsonObject> searchAsync(Qr qr) {
        this.POJO_MAP.forEach(this.joinder::pojo);
        return this.joinder.searchPaginationAsync(qr, this.merged);
    }

    public JsonArray fetch(Qr qr) {
        this.POJO_MAP.forEach(this.joinder::pojo);
        return this.joinder.searchArray(qr, this.merged);
    }

    public JsonArray fetch(JsonObject params) {
        return this.fetch(this.toQr(new JsonObject().put("criteria", params)));
    }

    public Future<JsonArray> fetchAsync(Qr qr) {
        return Ux.future(this.fetch(qr));
    }

    public Future<JsonArray> fetchAsync(JsonObject params) {
        return this.fetchAsync(this.toQr(new JsonObject().put("criteria", params)));
    }
}

