/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.Format;
import io.vertx.up.exception.zero.JooqClassInvalidException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.JqAggregator;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.JqReader;
import io.vertx.up.uca.jooq.JqWriter;
import io.vertx.up.uca.jooq.util.JqFlow;
import io.vertx.up.uca.jooq.util.JqTool;
import io.vertx.up.util.Ut;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;

public final class UxJooq {
    private static final Annal LOGGER = Annal.get(UxJooq.class);
    private final transient Class<?> clazz;
    private final transient JqAnalyzer analyzer;
    private final transient JqAggregator aggregator;
    private final transient JqWriter writer;
    private final transient JqReader reader;
    private final transient JqFlow workflow;
    private transient Format format = Format.JSON;

    public <T> UxJooq(Class<T> clazz, VertxDAO vertxDAO) {
        Fn.out((!Ut.isImplement(clazz, VertxDAO.class) ? 1 : 0) != 0, JooqClassInvalidException.class, (Object[])new Object[]{UxJooq.class, clazz.getName()});
        this.clazz = clazz;
        this.analyzer = JqAnalyzer.create(vertxDAO);
        this.aggregator = JqAggregator.create(this.analyzer);
        this.reader = JqReader.create(this.analyzer);
        this.writer = JqWriter.create(this.analyzer);
        this.workflow = JqFlow.create(this.analyzer);
    }

    public UxJooq on(String pojo) {
        this.analyzer.on(pojo, this.clazz);
        this.workflow.on(this.analyzer);
        return this;
    }

    public UxJooq on(Format format) {
        this.format = format;
        return this;
    }

    public JqAnalyzer analyzer() {
        return this.analyzer;
    }

    public Set<String> columns() {
        return this.analyzer.columns().keySet();
    }

    public String table() {
        return this.analyzer.table();
    }

    public <T> Future<T> insertAsync(T entity) {
        return this.writer.insertAsync(entity);
    }

    public <T> Future<T> insertAsync(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::insertAsync);
    }

    public <T> Future<T> insertAsync(JsonObject data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(this::insertAsync);
    }

    public <T> Future<JsonObject> insertJAsync(T entity) {
        return this.insertAsync(entity).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> insertJAsync(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::insertAsync).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> insertJAsync(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(this::insertAsync).compose(flow::outputAsync);
    }

    public <T> T insert(T entity) {
        return this.writer.insert(entity);
    }

    public <T> T insert(JsonObject data) {
        return this.insert(this.workflow.input(data));
    }

    public <T> T insert(JsonObject data, String pojo) {
        return this.insert(JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonObject insertJ(T entity) {
        return this.workflow.output(this.insert(entity));
    }

    public <T> JsonObject insertJ(JsonObject data) {
        return this.workflow.output(this.insert(this.workflow.input(data)));
    }

    public <T> JsonObject insertJ(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.insert(flow.input(data)));
    }

    public <T> Future<List<T>> insertAsync(List<T> entities) {
        return this.writer.insertAsync(entities);
    }

    public <T> Future<List<T>> insertAsync(JsonArray input) {
        return this.workflow.inputAsync(input).compose(this::insertAsync);
    }

    public <T> Future<List<T>> insertAsync(JsonArray input, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(input).compose(this::insertAsync);
    }

    public <T> Future<JsonArray> insertJAsync(List<T> list) {
        return this.insertAsync(list).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> insertJAsync(JsonArray input) {
        return this.workflow.inputAsync(input).compose(this::insertAsync).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> insertJAsync(JsonArray input, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(input).compose(this::insertAsync).compose(flow::outputAsync);
    }

    public <T> List<T> insert(List<T> entities) {
        return this.writer.insert(entities);
    }

    public <T> List<T> insert(JsonArray data) {
        return this.insert(this.workflow.input(data));
    }

    public <T> List<T> insert(JsonArray data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return this.insert(flow.input(data));
    }

    public <T> JsonArray insertJ(List<T> list) {
        return this.workflow.output(this.insert(list));
    }

    public JsonArray insertJ(JsonArray data) {
        return this.workflow.output(this.insert(this.workflow.input(data)));
    }

    public <T> JsonArray insertJ(JsonArray data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.insert(flow.input(data)));
    }

    public Future<JsonObject> searchAsync(JsonObject params, String pojo) {
        return this.reader.searchAsync(params, JqFlow.create(this.analyzer, pojo));
    }

    public Future<JsonObject> searchAsync(JsonObject params) {
        return this.reader.searchAsync(params, this.workflow);
    }

    public JsonObject search(JsonObject params, String pojo) {
        return this.reader.search(params, JqFlow.create(this.analyzer, pojo));
    }

    public JsonObject search(JsonObject params) {
        return this.reader.search(params, this.workflow);
    }

    public <T> Future<List<T>> fetchAllAsync() {
        return this.reader.fetchAllAsync();
    }

    public Future<JsonArray> fetchJAllAsync() {
        return this.fetchAllAsync().compose(this.workflow::outputAsync);
    }

    public Future<JsonArray> fetchJAllAsync(String pojo) {
        return this.fetchAllAsync().compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> List<T> fetchAll() {
        return this.reader.fetchAll();
    }

    public JsonArray fetchJAll() {
        return this.workflow.output(this.fetchAll());
    }

    public JsonArray fetchJAll(String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.fetchAll());
    }

    public <T> Future<List<T>> fetchAsync(String field, Object value) {
        return this.reader.fetchAsync(field, value);
    }

    public <T> Future<List<T>> fetchInAsync(String field, Object ... value) {
        return this.fetchAsync(field, Arrays.asList(value));
    }

    public <T> Future<List<T>> fetchInAsync(String field, JsonArray values) {
        return this.fetchAsync(field, values.getList());
    }

    public <T, K> Future<List<T>> fetchInAsync(String field, Collection<K> collection) {
        return this.fetchAsync(field, collection);
    }

    public Future<JsonArray> fetchJAsync(String field, Object value) {
        return this.fetchAsync(field, value).compose(this.workflow::outputAsync);
    }

    public Future<JsonArray> fetchJInAsync(String field, Object ... value) {
        return this.fetchAsync(field, Arrays.asList(value)).compose(this.workflow::outputAsync);
    }

    public Future<JsonArray> fetchJInAsync(String field, JsonArray values) {
        return this.fetchAsync(field, values.getList()).compose(this.workflow::outputAsync);
    }

    public <K> Future<JsonArray> fetchJInAsync(String field, Collection<K> collection) {
        return this.fetchAsync(field, collection).compose(this.workflow::outputAsync);
    }

    public <T> List<T> fetch(String field, Object value) {
        return this.reader.fetch(field, value);
    }

    public <T> List<T> fetchIn(String field, Object ... values) {
        return this.fetch(field, Arrays.asList(values));
    }

    public <T> List<T> fetchIn(String field, JsonArray values) {
        return this.fetch(field, values.getList());
    }

    public <T, K> List<T> fetchIn(String field, Collection<K> collection) {
        return this.fetch(field, collection);
    }

    public JsonArray fetchJ(String field, Object value) {
        return this.workflow.output(this.fetch(field, value));
    }

    public JsonArray fetchJIn(String field, Object ... values) {
        return this.workflow.output(this.fetch(field, Arrays.asList(values)));
    }

    public JsonArray fetchJIn(String field, JsonArray values) {
        return this.workflow.output(this.fetch(field, values.getList()));
    }

    public <K> JsonArray fetchJIn(String field, Collection<K> collection) {
        return this.workflow.output(this.fetch(field, collection));
    }

    public <T> Future<List<T>> fetchAsync(JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(this.reader::fetchAsync);
    }

    public <T> Future<List<T>> fetchAndAsync(JsonObject criteria) {
        return this.fetchAsync(criteria.put("", Boolean.TRUE));
    }

    public <T> Future<List<T>> fetchOrAsync(JsonObject criteria) {
        return this.fetchAsync(criteria.put("", Boolean.FALSE));
    }

    public Future<JsonArray> fetchJAsync(JsonObject criteria) {
        return this.fetchAsync(criteria).compose(this.workflow::outputAsync);
    }

    public Future<JsonArray> fetchJAndAsync(JsonObject criteria) {
        return this.fetchAsync(criteria.put("", Boolean.TRUE)).compose(this.workflow::outputAsync);
    }

    public Future<JsonArray> fetchJOrAsync(JsonObject criteria) {
        return this.fetchAsync(criteria.put("", Boolean.FALSE)).compose(this.workflow::outputAsync);
    }

    public <T> List<T> fetch(JsonObject criteria) {
        return this.reader.fetch(this.workflow.inputQrJ(criteria));
    }

    public <T> List<T> fetchAnd(JsonObject criteria) {
        return this.fetch(criteria.put("", Boolean.TRUE));
    }

    public <T> List<T> fetchOr(JsonObject criteria) {
        return this.fetch(criteria.put("", Boolean.FALSE));
    }

    public JsonArray fetchJ(JsonObject criteria) {
        return this.workflow.output(this.fetch(criteria));
    }

    public JsonArray fetchJAnd(JsonObject criteria) {
        return this.workflow.output(this.fetch(criteria.put("", Boolean.TRUE)));
    }

    public JsonArray fetchJOr(JsonObject criteria) {
        return this.workflow.output(this.fetch(criteria.put("", Boolean.FALSE)));
    }

    public <T> Future<List<T>> fetchAsync(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(this.reader::fetchAsync);
    }

    public <T> Future<List<T>> fetchAndAsync(JsonObject criteria, String pojo) {
        return this.fetchAsync(criteria.put("", Boolean.TRUE), pojo);
    }

    public <T> Future<List<T>> fetchOrAsync(JsonObject criteria, String pojo) {
        return this.fetchAsync(criteria.put("", Boolean.FALSE), pojo);
    }

    public Future<JsonArray> fetchJAsync(JsonObject criteria, String pojo) {
        return this.fetchAsync(criteria, pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public Future<JsonArray> fetchJAndAsync(JsonObject criteria, String pojo) {
        return this.fetchAsync(criteria.put("", Boolean.TRUE), pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public Future<JsonArray> fetchJOrAsync(JsonObject criteria, String pojo) {
        return this.fetchAsync(criteria.put("", Boolean.FALSE), pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> List<T> fetch(JsonObject criteria, String pojo) {
        return this.reader.fetch(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public <T> List<T> fetchAnd(JsonObject criteria, String pojo) {
        return this.fetch(criteria.put("", Boolean.TRUE), pojo);
    }

    public <T> List<T> fetchOr(JsonObject criteria, String pojo) {
        return this.fetch(criteria.put("", Boolean.FALSE), pojo);
    }

    public JsonArray fetchJ(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.fetch(criteria, pojo));
    }

    public JsonArray fetchJAnd(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.fetch(criteria.put("", Boolean.TRUE), pojo));
    }

    public JsonArray fetchJOr(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.fetch(criteria.put("", Boolean.FALSE), pojo));
    }

    public <T> Future<T> fetchByIdAsync(Object id) {
        return this.reader.fetchByIdAsync(id);
    }

    public Future<JsonObject> fetchJByIdAsync(Object id) {
        return this.fetchByIdAsync(id).compose(this.workflow::outputAsync);
    }

    public <T> T fetchById(Object id) {
        return this.reader.fetchById(id);
    }

    public <T> JsonObject fetchJById(Object id) {
        return this.workflow.output(this.fetchById(id));
    }

    public <T> Future<T> fetchOneAsync(String field, Object value) {
        return this.reader.fetchOneAsync(field, value);
    }

    public Future<JsonObject> fetchJOneAsync(String field, Object value) {
        return this.fetchOneAsync(field, value).compose(this.workflow::outputAsync);
    }

    public <T> T fetchOne(String field, Object value) {
        return this.reader.fetchOne(field, value);
    }

    public <T> JsonObject fetchJOne(String field, Object value) {
        return this.workflow.output(this.fetchOne(field, value));
    }

    public <T> Future<T> fetchOneAsync(JsonObject criteria) {
        criteria.put("", Boolean.TRUE);
        return this.workflow.inputQrJAsync(criteria).compose(this.reader::fetchOneAsync);
    }

    public Future<JsonObject> fetchJOneAsync(JsonObject criteria) {
        return this.fetchOneAsync(criteria).compose(this.workflow::outputAsync);
    }

    public <T> T fetchOne(JsonObject criteria) {
        criteria.put("", Boolean.TRUE);
        return this.reader.fetchOne(this.workflow.inputQrJ(criteria));
    }

    public <T> JsonObject fetchJOne(JsonObject criteria) {
        return this.workflow.output(this.fetchOne(criteria));
    }

    public <T> Future<T> fetchOneAsync(JsonObject criteria, String pojo) {
        criteria.put("", Boolean.TRUE);
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(this.reader::fetchOneAsync);
    }

    public Future<JsonObject> fetchJOneAsync(JsonObject criteria, String pojo) {
        return this.fetchOneAsync(criteria, pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> T fetchOne(JsonObject criteria, String pojo) {
        criteria.put("", Boolean.TRUE);
        return this.reader.fetchOne(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public <T> JsonObject fetchJOne(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.fetchOne(criteria, pojo));
    }

    public <T> T update(T entity) {
        return this.writer.update(entity);
    }

    public <T> T update(JsonObject data) {
        return this.update(this.workflow.input(data));
    }

    public <T> T update(JsonObject data, String pojo) {
        return this.update(JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonObject updateJ(T entity) {
        return this.workflow.output(this.update(entity));
    }

    public <T> JsonObject updateJ(JsonObject data) {
        return this.workflow.output(this.update(this.workflow.input(data)));
    }

    public <T> JsonObject updateJ(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.update(flow.input(data)));
    }

    public <T> Future<T> updateAsync(T entity) {
        return this.writer.updateAsync(entity);
    }

    public <T> Future<T> updateAsync(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::updateAsync);
    }

    public <T> Future<T> updateAsync(JsonObject data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(this::updateAsync);
    }

    public <T> Future<JsonObject> updateAsyncJ(T entity) {
        return this.updateAsync(entity).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> updateAsyncJ(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::updateAsync).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> updateAsyncJ(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(this::updateAsync).compose(flow::outputAsync);
    }

    public <T> List<T> update(List<T> entities) {
        return this.writer.update(entities);
    }

    public <T> List<T> update(JsonArray data) {
        return this.update(this.workflow.input(data));
    }

    public <T> List<T> update(JsonArray data, String pojo) {
        return this.update(JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonArray updateJ(List<T> entities) {
        return this.workflow.output(this.update(entities));
    }

    public JsonArray updateJ(JsonArray data) {
        return this.workflow.output(this.update(this.workflow.input(data)));
    }

    public <T> JsonArray updateJ(JsonArray data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.update(flow.input(data)));
    }

    public <T> Future<List<T>> updateAsync(List<T> entities) {
        return this.writer.updateAsync(entities);
    }

    public <T> Future<List<T>> updateAsync(JsonArray data) {
        return this.workflow.inputAsync(data).compose(this::updateAsync);
    }

    public <T> Future<List<T>> updateAsync(JsonArray data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(this::updateAsync);
    }

    public <T> Future<JsonArray> updateAsyncJ(List<T> entities) {
        return this.updateAsync(entities).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> updateAsyncJ(JsonArray input) {
        return this.workflow.inputAsync(input).compose(this::updateAsync).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> updateAsyncJ(JsonArray input, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(input).compose(this::updateAsync).compose(flow::outputAsync);
    }

    public <T> T update(Object id, T updated) {
        return this.writer.update(id, updated);
    }

    public <T> T update(Object id, JsonObject data) {
        return this.update(id, this.workflow.input(data));
    }

    public <T> T update(Object id, JsonObject data, String pojo) {
        return this.update(id, JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonObject updateJ(Object id, T updated) {
        return this.workflow.output(this.update(id, updated));
    }

    public <T> JsonObject updateJ(Object id, JsonObject data) {
        return this.workflow.output(this.update(id, this.workflow.input(data)));
    }

    public <T> JsonObject updateJ(Object id, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.update(id, flow.input(data)));
    }

    public <T, ID> Future<T> updateAsync(ID id, T updated) {
        return this.writer.updateAsync(id, updated);
    }

    public <T, ID> Future<T> updateAsync(ID id, JsonObject data) {
        return this.workflow.inputAsync(data).compose(entity -> this.updateAsync(id, entity));
    }

    public <T, ID> Future<T> updateAsync(ID id, JsonObject data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(entity -> this.updateAsync(id, entity));
    }

    public <T, ID> Future<JsonObject> updateJAsync(ID id, T updated) {
        return this.updateAsync(id, updated).compose(this.workflow::outputAsync);
    }

    public <T, ID> Future<JsonObject> updateJAsync(ID id, JsonObject data) {
        return this.workflow.inputAsync(data).compose(entity -> this.updateAsync(id, entity)).compose(this.workflow::outputAsync);
    }

    public <T, ID> Future<JsonObject> updateJAsync(ID id, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(entity -> this.updateAsync(id, entity)).compose(flow::outputAsync);
    }

    public <T> T update(JsonObject criteria, T updated) {
        criteria.put("", Boolean.TRUE);
        return this.writer.update(this.workflow.inputQrJ(criteria), updated);
    }

    public <T> T update(JsonObject criteria, JsonObject data) {
        return this.update(criteria, this.workflow.input(data));
    }

    public <T> JsonObject updateJ(JsonObject criteria, T updated) {
        return this.workflow.output(this.update(criteria, updated));
    }

    public <T> JsonObject updateJ(JsonObject criteria, JsonObject data) {
        return this.workflow.output(this.update(criteria, this.workflow.input(data)));
    }

    public <T> T update(JsonObject criteria, T updated, String pojo) {
        criteria.put("", Boolean.TRUE);
        return this.writer.update(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria), updated);
    }

    public <T> T update(JsonObject criteria, JsonObject data, String pojo) {
        return this.update(criteria, JqFlow.create(this.analyzer, pojo).input(data), pojo);
    }

    public <T> JsonObject updateJ(JsonObject criteria, T updated, String pojo) {
        return this.workflow.output(this.update(criteria, updated, pojo));
    }

    public <T> JsonObject updateJ(JsonObject criteria, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.update(criteria, flow.input(data), pojo));
    }

    public <T> Future<T> updateAsync(JsonObject criteria, T updated) {
        criteria.put("", Boolean.TRUE);
        return this.workflow.inputQrJAsync(criteria).compose(normalized -> this.writer.updateAsync((JsonObject)normalized, updated));
    }

    public <T> Future<T> updateAsync(JsonObject criteria, JsonObject data) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.updateAsync((JsonObject)response.resultAt(0), response.resultAt(1)));
    }

    public <T> Future<JsonObject> updateJAsync(JsonObject criteria, T updated) {
        return this.updateAsync(criteria, updated).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> updateJAsync(JsonObject criteria, JsonObject data) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.updateAsync((JsonObject)response.resultAt(0), response.resultAt(1))).compose(this.workflow::outputAsync);
    }

    public <T> Future<T> updateAsync(JsonObject criteria, T updated, String pojo) {
        criteria.put("", Boolean.TRUE);
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(normalized -> this.writer.updateAsync((JsonObject)normalized, updated));
    }

    public <T> Future<T> updateAsync(JsonObject criteria, JsonObject data, String pojo) {
        return JqTool.joinAsync(criteria, data, JqFlow.create(this.analyzer, pojo)).compose(response -> this.updateAsync((JsonObject)response.resultAt(0), response.resultAt(1), pojo));
    }

    public <T> Future<JsonObject> updateJAsync(JsonObject criteria, T updated, String pojo) {
        return this.updateAsync(criteria, updated, pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> Future<JsonObject> updateJAsync(JsonObject criteria, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return JqTool.joinAsync(criteria, data, flow).compose(response -> this.updateAsync((JsonObject)response.resultAt(0), response.resultAt(1), pojo)).compose(flow::outputAsync);
    }

    public <T> T upsert(Object id, T updated) {
        return this.writer.upsert(id, updated);
    }

    public <T> T upsert(Object id, JsonObject data) {
        return this.upsert(id, this.workflow.input(data));
    }

    public <T> T upsert(Object id, JsonObject data, String pojo) {
        return this.upsert(id, JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonObject upsertJ(Object id, T updated) {
        return this.workflow.output(this.upsert(id, updated));
    }

    public <T> JsonObject upsertJ(Object id, JsonObject data) {
        return this.workflow.output(this.upsert(id, this.workflow.input(data)));
    }

    public <T> JsonObject upsertJ(Object id, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.upsert(id, flow.input(data)));
    }

    public <T> Future<T> upsertAsync(Object id, T updated) {
        return this.writer.upsertAsync(id, updated);
    }

    public <T> Future<T> upsertAsync(Object id, JsonObject data) {
        return this.workflow.inputAsync(data).compose(updated -> this.upsertAsync(id, updated));
    }

    public <T> Future<T> upsertAsync(Object id, JsonObject data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(updated -> this.upsertAsync(id, updated));
    }

    public <T> Future<JsonObject> upsertJAsync(Object id, T updated) {
        return this.upsertAsync(id, updated).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> upsertJAsync(Object id, JsonObject data) {
        return this.workflow.inputAsync(data).compose(updated -> this.upsertAsync(id, updated)).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> upsertJAsync(Object id, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(updated -> this.upsertAsync(id, updated)).compose(flow::outputAsync);
    }

    public <T> T upsert(JsonObject criteria, T updated) {
        criteria.put("", Boolean.TRUE);
        return this.writer.upsert(this.workflow.inputQrJ(criteria), updated);
    }

    public <T> T upsert(JsonObject criteria, JsonObject data) {
        return this.upsert(criteria, this.workflow.input(data));
    }

    public <T> JsonObject upsertJ(JsonObject criteria, T updated) {
        return this.workflow.output(this.upsert(criteria, updated));
    }

    public <T> JsonObject upsertJ(JsonObject criteria, JsonObject data) {
        return this.workflow.output(this.upsert(criteria, this.workflow.input(data)));
    }

    public <T> T upsert(JsonObject criteria, T updated, String pojo) {
        criteria.put("", Boolean.TRUE);
        return this.writer.upsert(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria), updated);
    }

    public <T> T upsert(JsonObject criteria, JsonObject data, String pojo) {
        return this.upsert(criteria, JqFlow.create(this.analyzer, pojo).input(data), pojo);
    }

    public <T> JsonObject upsertJ(JsonObject criteria, T updated, String pojo) {
        return this.workflow.output(this.upsert(criteria, updated, pojo));
    }

    public <T> JsonObject upsertJ(JsonObject criteria, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.upsert(criteria, flow.input(data), pojo));
    }

    public <T> Future<T> upsertAsync(JsonObject criteria, T updated) {
        criteria.put("", Boolean.TRUE);
        return this.workflow.inputQrJAsync(criteria).compose(normalized -> this.writer.upsertAsync(normalized, updated));
    }

    public <T> Future<T> upsertAsync(JsonObject criteria, JsonObject data) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), response.resultAt(1)));
    }

    public <T> Future<JsonObject> upsertJAsync(JsonObject criteria, T updated) {
        return this.upsertAsync(criteria, updated).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonObject> upsertJAsync(JsonObject criteria, JsonObject data) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), response.resultAt(1))).compose(this.workflow::outputAsync);
    }

    public <T> Future<T> upsertAsync(JsonObject criteria, T updated, String pojo) {
        criteria.put("", Boolean.TRUE);
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(normalized -> this.writer.upsertAsync(normalized, updated));
    }

    public <T> Future<T> upsertAsync(JsonObject criteria, JsonObject data, String pojo) {
        return JqTool.joinAsync(criteria, data, JqFlow.create(this.analyzer, pojo)).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), response.resultAt(1), pojo));
    }

    public <T> Future<JsonObject> upsertJAsync(JsonObject criteria, T updated, String pojo) {
        return this.upsertAsync(criteria, updated, pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> Future<JsonObject> upsertJAsync(JsonObject criteria, JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return JqTool.joinAsync(criteria, data, flow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), response.resultAt(1), pojo)).compose(flow::outputAsync);
    }

    public <T> List<T> upsert(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.writer.upsert(this.workflow.inputQrJ(criteria), list, finder);
    }

    public <T> List<T> upsert(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder) {
        return this.upsert(criteria, this.workflow.input(data), finder);
    }

    public <T> JsonArray upsertJ(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.workflow.output(this.upsert(criteria, list, finder));
    }

    public <T> JsonArray upsertJ(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder) {
        return this.workflow.output(this.upsert(criteria, this.workflow.input(data), finder));
    }

    public <T> List<T> upsert(JsonObject criteria, List<T> list, BiPredicate<T, T> finder, String pojo) {
        return this.writer.upsert(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria), list, finder);
    }

    public <T> List<T> upsert(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder, String pojo) {
        return this.upsert(criteria, JqFlow.create(this.analyzer, pojo).input(data), finder, pojo);
    }

    public <T> JsonArray upsertJ(JsonObject criteria, List<T> list, BiPredicate<T, T> finder, String pojo) {
        return JqFlow.create(this.analyzer, pojo).output(this.upsert(criteria, list, finder, pojo));
    }

    public <T> JsonArray upsertJ(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.upsert(criteria, flow.input(data), finder, pojo));
    }

    public <T> Future<List<T>> upsertAsync(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.workflow.inputQrJAsync(criteria).compose(normalized -> this.writer.upsertAsync((JsonObject)normalized, list, finder));
    }

    public <T> Future<List<T>> upsertAsync(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), (List)response.resultAt(1), finder));
    }

    public <T> Future<JsonArray> upsertJAsync(JsonObject criteria, List<T> list, BiPredicate<T, T> finder) {
        return this.upsertAsync(criteria, list, finder).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> upsertJAsync(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder) {
        return JqTool.joinAsync(criteria, data, this.workflow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), (List)response.resultAt(1), finder)).compose(this.workflow::outputAsync);
    }

    public <T> Future<List<T>> upsertAsync(JsonObject criteria, List<T> list, BiPredicate<T, T> finder, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(normalized -> this.writer.upsertAsync((JsonObject)normalized, list, finder));
    }

    public <T> Future<List<T>> upsertAsync(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder, String pojo) {
        return JqTool.joinAsync(criteria, data, JqFlow.create(this.analyzer, pojo)).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), (List)response.resultAt(1), finder, pojo));
    }

    public <T> Future<JsonArray> upsertJAsync(JsonObject criteria, List<T> list, BiPredicate<T, T> finder, String pojo) {
        return this.upsertAsync(criteria, list, finder, pojo).compose(JqFlow.create(this.analyzer, pojo)::outputAsync);
    }

    public <T> Future<JsonArray> upsertJAsync(JsonObject criteria, JsonArray data, BiPredicate<T, T> finder, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return JqTool.joinAsync(criteria, data, flow).compose(response -> this.upsertAsync((JsonObject)response.resultAt(0), (List)response.resultAt(1), finder, pojo)).compose(flow::outputAsync);
    }

    public <T> T delete(T entity) {
        return this.writer.delete(entity);
    }

    public <T> T delete(JsonObject data) {
        return this.delete(this.workflow.input(data));
    }

    public <T> T delete(JsonObject data, String pojo) {
        return this.delete(JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonObject deleteJ(T entity) {
        return this.workflow.output(this.delete(entity));
    }

    public <T> JsonObject deleteJ(JsonObject data) {
        return this.workflow.output(this.delete(this.workflow.input(data)));
    }

    public <T> JsonObject deleteJ(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.delete(flow.input(data)));
    }

    public <T, ID> Future<T> deleteAsync(T entity) {
        return this.writer.deleteAsync(entity);
    }

    public <T, ID> Future<T> deleteAsync(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::deleteAsync);
    }

    public <T, ID> Future<T> deleteAsync(JsonObject data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(this::deleteAsync);
    }

    public <T, ID> Future<JsonObject> deleteJAsync(T entity) {
        return this.deleteAsync(entity).compose(this.workflow::outputAsync);
    }

    public <T, ID> Future<JsonObject> deleteJAsync(JsonObject data) {
        return this.workflow.inputAsync(data).compose(this::deleteAsync).compose(this.workflow::outputAsync);
    }

    public <T, ID> Future<JsonObject> deleteJAsync(JsonObject data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(this::deleteAsync).compose(flow::outputAsync);
    }

    public <T> List<T> delete(List<T> entity) {
        return this.writer.delete(entity);
    }

    public <T> List<T> delete(JsonArray data) {
        return this.delete(this.workflow.input(data));
    }

    public <T> List<T> delete(JsonArray data, String pojo) {
        return this.delete(JqFlow.create(this.analyzer, pojo).input(data));
    }

    public <T> JsonArray deleteJ(List<T> entity) {
        return this.workflow.output(this.delete(entity));
    }

    public <T> JsonArray deleteJ(JsonArray data) {
        return this.workflow.output(this.delete(this.workflow.input(data)));
    }

    public <T> JsonArray deleteJ(JsonArray data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.output(this.delete(flow.input(data)));
    }

    public <T> Future<List<T>> deleteAsync(List<T> entity) {
        return this.writer.deleteAsync(entity);
    }

    public <T> Future<List<T>> deleteAsync(JsonArray data) {
        return this.workflow.inputAsync(data).compose(this::deleteAsync);
    }

    public <T> Future<List<T>> deleteAsync(JsonArray data, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputAsync(data).compose(this::deleteAsync);
    }

    public <T> Future<JsonArray> deleteJAsync(List<T> entity) {
        return this.deleteAsync(entity).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> deleteJAsync(JsonArray data) {
        return this.workflow.inputAsync(data).compose(this::deleteAsync).compose(this.workflow::outputAsync);
    }

    public <T> Future<JsonArray> deleteJAsync(JsonArray data, String pojo) {
        JqFlow flow = JqFlow.create(this.analyzer, pojo);
        return flow.inputAsync(data).compose(this::deleteAsync).compose(flow::outputAsync);
    }

    public final Boolean deleteById(Object id) {
        return this.writer.deleteById(Arrays.asList(id));
    }

    public Boolean deleteById(Collection<Object> ids) {
        return this.writer.deleteById(ids);
    }

    public final Future<Boolean> deleteByIdAsync(Object id) {
        return this.writer.deleteByIdAsync(Arrays.asList(id));
    }

    public Future<Boolean> deleteByIdAsync(Collection<Object> ids) {
        return this.writer.deleteByIdAsync(ids);
    }

    public Future<Boolean> deleteByAsync(JsonObject criteria) {
        criteria.put("", Boolean.TRUE);
        return this.workflow.inputQrJAsync(criteria).compose(this.writer::deleteByAsync);
    }

    public Future<Boolean> deleteByAsync(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(this.writer::deleteByAsync);
    }

    public Boolean deleteBy(JsonObject criteria) {
        criteria.put("", Boolean.TRUE);
        return this.writer.deleteBy(this.workflow.inputQrJ(criteria));
    }

    public Boolean deleteBy(JsonObject criteria, String pojo) {
        return this.writer.deleteBy(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Boolean existById(Object id) {
        return this.reader.existById(id);
    }

    public Future<Boolean> existByIdAsync(Object id) {
        return this.reader.existByIdAsync(id);
    }

    public Boolean missById(Object id) {
        return this.existById(id) == false;
    }

    public Future<Boolean> missByIdAsync(Object id) {
        return this.existByIdAsync(id).compose(result -> Future.succeededFuture((Object)(result == false ? 1 : 0)));
    }

    public Boolean exist(JsonObject criteria) {
        return this.reader.exist(this.workflow.inputQrJ(criteria));
    }

    public Boolean exist(JsonObject criteria, String pojo) {
        return this.reader.exist(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<Boolean> existAsync(JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(this.reader::existAsync);
    }

    public Future<Boolean> existAsync(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(this.reader::existAsync);
    }

    public Boolean miss(JsonObject criteria) {
        return this.exist(criteria) == false;
    }

    public Boolean miss(JsonObject criteria, String pojo) {
        return this.exist(criteria, pojo) == false;
    }

    public Future<Boolean> missAsync(JsonObject criteria) {
        return this.existAsync(criteria).compose(existing -> Future.succeededFuture((Object)(existing == false ? 1 : 0)));
    }

    public Future<Boolean> missAsync(JsonObject criteria, String pojo) {
        return this.existAsync(criteria, pojo).compose(existing -> Future.succeededFuture((Object)(existing == false ? 1 : 0)));
    }

    public <T> ConcurrentMap<String, List<T>> group(String field) {
        return this.aggregator.group(field);
    }

    public <T> ConcurrentMap<String, JsonArray> groupJ(String field) {
        return this.workflow.output(this.group(field));
    }

    public <T> Future<ConcurrentMap<String, List<T>>> groupAsync(String field) {
        return Future.succeededFuture(this.group(field));
    }

    public <T> Future<ConcurrentMap<String, JsonArray>> groupJAsync(String field) {
        return Future.succeededFuture(this.group(field)).compose(this.workflow::outputAsync);
    }

    public <T> ConcurrentMap<String, List<T>> group(JsonObject criteria, String field) {
        return this.aggregator.group(this.workflow.inputQrJ(criteria), field);
    }

    public <T> ConcurrentMap<String, JsonArray> groupJ(JsonObject criteria, String field) {
        return this.workflow.output(this.group(criteria, field));
    }

    public <T> Future<ConcurrentMap<String, List<T>>> groupAsync(JsonObject criteria, String field) {
        return Future.succeededFuture(this.group(criteria, field));
    }

    public <T> Future<ConcurrentMap<String, JsonArray>> groupJAsync(JsonObject criteria, String field) {
        return Future.succeededFuture(this.group(criteria, field)).compose(this.workflow::outputAsync);
    }

    public Long countAll() {
        return this.aggregator.countAll();
    }

    public Future<Long> countAllAsync() {
        return this.aggregator.countAllAsync();
    }

    public Long count(JsonObject criteria) {
        return this.aggregator.count(this.workflow.inputQrJ(criteria));
    }

    public Long count(JsonObject criteria, String pojo) {
        return this.aggregator.count(JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<Long> countAsync(JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(this.aggregator::countAsync);
    }

    public Future<Long> countAsync(JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(this.aggregator::countAsync);
    }

    public ConcurrentMap<String, Integer> countBy(JsonObject criteria, String groupField) {
        return this.aggregator.countBy(this.workflow.inputQrJ(criteria), groupField);
    }

    public ConcurrentMap<String, Integer> countBy(String groupField) {
        return this.countBy(new JsonObject(), groupField);
    }

    public Future<ConcurrentMap<String, Integer>> countByAsync(JsonObject criteria, String groupField) {
        return Future.succeededFuture(this.countBy(criteria, groupField));
    }

    public Future<ConcurrentMap<String, Integer>> countByAsync(String groupField) {
        return Future.succeededFuture(this.countBy(new JsonObject(), groupField));
    }

    public JsonArray countBy(JsonObject criteria, String ... groupFields) {
        return this.aggregator.countBy(this.workflow.inputQrJ(criteria), groupFields);
    }

    public JsonArray countBy(String ... groupFields) {
        return this.countBy(new JsonObject(), groupFields);
    }

    public Future<JsonArray> countByAsync(String ... groupFields) {
        return Future.succeededFuture((Object)this.countBy(new JsonObject(), groupFields));
    }

    public Future<JsonArray> countByAsync(JsonObject criteria, String ... groupFields) {
        return Future.succeededFuture((Object)this.countBy(criteria, groupFields));
    }

    public BigDecimal sum(String field) {
        return this.aggregator.sum(field, null);
    }

    public Future<BigDecimal> sumAsync(String field) {
        return Future.succeededFuture((Object)this.aggregator.sum(field, null));
    }

    public BigDecimal sum(String field, JsonObject criteria) {
        return this.aggregator.sum(field, this.workflow.inputQrJ(criteria));
    }

    public Future<BigDecimal> sumAsync(String field, JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.sum(field, (JsonObject)processed)));
    }

    public BigDecimal sum(String field, JsonObject criteria, String pojo) {
        return this.aggregator.sum(field, JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<BigDecimal> sumAsync(String field, JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.sum(field, (JsonObject)processed)));
    }

    public ConcurrentMap<String, BigDecimal> sumBy(String field, JsonObject criteria, String groupField) {
        return this.aggregator.sum(field, this.workflow.inputQrJ(criteria), groupField);
    }

    public ConcurrentMap<String, BigDecimal> sumBy(String field, String groupField) {
        return this.sumBy(field, new JsonObject(), groupField);
    }

    public Future<ConcurrentMap<String, BigDecimal>> sumByAsync(String field, String groupField) {
        return Future.succeededFuture(this.sumBy(field, new JsonObject(), groupField));
    }

    public Future<ConcurrentMap<String, BigDecimal>> sumByAsync(String field, JsonObject criteria, String groupField) {
        return Future.succeededFuture(this.sumBy(field, criteria, groupField));
    }

    public JsonArray sumBy(String field, JsonObject criteria, String ... groupFields) {
        return this.aggregator.sum(field, this.workflow.inputQrJ(criteria), groupFields);
    }

    public JsonArray sumBy(String field, String ... groupFields) {
        return this.sumBy(field, new JsonObject(), groupFields);
    }

    public Future<JsonArray> sumByAsync(String field, JsonObject criteria, String ... groupFields) {
        return Future.succeededFuture((Object)this.sumBy(field, criteria, groupFields));
    }

    public Future<JsonArray> sumByAsync(String field, String ... groupFields) {
        return Future.succeededFuture((Object)this.sumBy(field, new JsonObject(), groupFields));
    }

    public BigDecimal max(String field) {
        return this.aggregator.max(field, null);
    }

    public Future<BigDecimal> maxAsync(String field) {
        return Future.succeededFuture((Object)this.aggregator.max(field, null));
    }

    public BigDecimal max(String field, JsonObject criteria) {
        return this.aggregator.max(field, this.workflow.inputQrJ(criteria));
    }

    public Future<BigDecimal> maxAsync(String field, JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.max(field, (JsonObject)processed)));
    }

    public BigDecimal max(String field, JsonObject criteria, String pojo) {
        return this.aggregator.max(field, JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<BigDecimal> maxAsync(String field, JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.max(field, (JsonObject)processed)));
    }

    public ConcurrentMap<String, BigDecimal> maxBy(String field, JsonObject criteria, String groupField) {
        return this.aggregator.max(field, this.workflow.inputQrJ(criteria), groupField);
    }

    public ConcurrentMap<String, BigDecimal> maxBy(String field, String groupField) {
        return this.maxBy(field, new JsonObject(), groupField);
    }

    public Future<ConcurrentMap<String, BigDecimal>> maxByAsync(String field, String groupField) {
        return Future.succeededFuture(this.maxBy(field, new JsonObject(), groupField));
    }

    public Future<ConcurrentMap<String, BigDecimal>> maxByAsync(String field, JsonObject criteria, String groupField) {
        return Future.succeededFuture(this.maxBy(field, criteria, groupField));
    }

    public JsonArray maxBy(String field, JsonObject criteria, String ... groupFields) {
        return this.aggregator.max(field, this.workflow.inputQrJ(criteria), groupFields);
    }

    public JsonArray maxBy(String field, String ... groupFields) {
        return this.maxBy(field, new JsonObject(), groupFields);
    }

    public Future<JsonArray> maxByAsync(String field, JsonObject criteria, String ... groupFields) {
        return Future.succeededFuture((Object)this.maxBy(field, criteria, groupFields));
    }

    public Future<JsonArray> maxByAsync(String field, String ... groupFields) {
        return Future.succeededFuture((Object)this.maxBy(field, new JsonObject(), groupFields));
    }

    public BigDecimal min(String field) {
        return this.aggregator.min(field, null);
    }

    public Future<BigDecimal> minAsync(String field) {
        return Future.succeededFuture((Object)this.aggregator.min(field, null));
    }

    public BigDecimal min(String field, JsonObject criteria) {
        return this.aggregator.min(field, this.workflow.inputQrJ(criteria));
    }

    public Future<BigDecimal> minAsync(String field, JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.min(field, (JsonObject)processed)));
    }

    public BigDecimal min(String field, JsonObject criteria, String pojo) {
        return this.aggregator.min(field, JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<BigDecimal> minAsync(String field, JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.min(field, (JsonObject)processed)));
    }

    public ConcurrentMap<String, BigDecimal> minBy(String field, JsonObject criteria, String groupField) {
        return this.aggregator.min(field, this.workflow.inputQrJ(criteria), groupField);
    }

    public ConcurrentMap<String, BigDecimal> minBy(String field, String groupField) {
        return this.minBy(field, new JsonObject(), groupField);
    }

    public Future<ConcurrentMap<String, BigDecimal>> minByAsync(String field, String groupField) {
        return Future.succeededFuture(this.minBy(field, new JsonObject(), groupField));
    }

    public Future<ConcurrentMap<String, BigDecimal>> minByAsync(String field, JsonObject criteria, String groupField) {
        return Future.succeededFuture(this.minBy(field, criteria, groupField));
    }

    public JsonArray minBy(String field, JsonObject criteria, String ... groupFields) {
        return this.aggregator.min(field, this.workflow.inputQrJ(criteria), groupFields);
    }

    public JsonArray minBy(String field, String ... groupFields) {
        return this.minBy(field, new JsonObject(), groupFields);
    }

    public Future<JsonArray> minByAsync(String field, JsonObject criteria, String ... groupFields) {
        return Future.succeededFuture((Object)this.minBy(field, criteria, groupFields));
    }

    public Future<JsonArray> minByAsync(String field, String ... groupFields) {
        return Future.succeededFuture((Object)this.minBy(field, new JsonObject(), groupFields));
    }

    public BigDecimal avg(String field) {
        return this.aggregator.avg(field, null);
    }

    public Future<BigDecimal> avgAsync(String field) {
        return Future.succeededFuture((Object)this.aggregator.avg(field, null));
    }

    public BigDecimal avg(String field, JsonObject criteria) {
        return this.aggregator.avg(field, this.workflow.inputQrJ(criteria));
    }

    public Future<BigDecimal> avgAsync(String field, JsonObject criteria) {
        return this.workflow.inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.avg(field, (JsonObject)processed)));
    }

    public BigDecimal avg(String field, JsonObject criteria, String pojo) {
        return this.aggregator.avg(field, JqFlow.create(this.analyzer, pojo).inputQrJ(criteria));
    }

    public Future<BigDecimal> avgAsync(String field, JsonObject criteria, String pojo) {
        return JqFlow.create(this.analyzer, pojo).inputQrJAsync(criteria).compose(processed -> Future.succeededFuture((Object)this.aggregator.avg(field, (JsonObject)processed)));
    }

    public ConcurrentMap<String, BigDecimal> avgBy(String field, JsonObject criteria, String groupField) {
        return this.aggregator.avg(field, this.workflow.inputQrJ(criteria), groupField);
    }

    public ConcurrentMap<String, BigDecimal> avgBy(String field, String groupField) {
        return this.avgBy(field, new JsonObject(), groupField);
    }

    public Future<ConcurrentMap<String, BigDecimal>> avgByAsync(String field, String groupField) {
        return Future.succeededFuture(this.avgBy(field, new JsonObject(), groupField));
    }

    public Future<ConcurrentMap<String, BigDecimal>> avgByAsync(String field, JsonObject criteria, String groupField) {
        return Future.succeededFuture(this.avgBy(field, criteria, groupField));
    }

    public JsonArray avgBy(String field, JsonObject criteria, String ... groupFields) {
        return this.aggregator.avg(field, this.workflow.inputQrJ(criteria), groupFields);
    }

    public JsonArray avgBy(String field, String ... groupFields) {
        return this.avgBy(field, new JsonObject(), groupFields);
    }

    public Future<JsonArray> avgByAsync(String field, JsonObject criteria, String ... groupFields) {
        return Future.succeededFuture((Object)this.avgBy(field, criteria, groupFields));
    }

    public Future<JsonArray> avgByAsync(String field, String ... groupFields) {
        return Future.succeededFuture((Object)this.avgBy(field, new JsonObject(), groupFields));
    }
}

