/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.cache;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.cache.hit.CMessage;
import io.vertx.tp.plugin.cache.hit.CMessageKey;
import io.vertx.tp.plugin.cache.hit.CMessageList;
import io.vertx.tp.plugin.cache.hit.CMessageTree;
import io.vertx.tp.plugin.cache.hit.CMessageUnique;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.ActionQr;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.uca.jooq.cache.L1Aside;
import io.vertx.up.uca.jooq.util.JqTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;

abstract class AbstractAside {
    AbstractAside() {
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected CMessage messageUniqueField(ProceedingJoinPoint point) {
        String field = (String)this.argument(point, 0);
        Object value = this.argument(point, 1);
        return this.messageUnique(field, value, point);
    }

    protected CMessage messageUniqueCond(ProceedingJoinPoint point) {
        JsonObject condition = (JsonObject)this.argument(point, 0);
        return this.messageUnique(condition, point);
    }

    protected CMessage messageUniquePojo(ProceedingJoinPoint point) {
        return this.messageUnique(this.argumentPojo(point, 0), point);
    }

    protected CMessage messageListField(ProceedingJoinPoint point) {
        String field = (String)this.argument(point, 0);
        Object value = this.argument(point, 1);
        return this.messageList(field, value, point);
    }

    protected CMessage messageListCond(ProceedingJoinPoint point) {
        JsonObject condition = (JsonObject)this.argument(point, 0);
        return this.messageList(condition, point);
    }

    protected CMessage messageListPojo(ProceedingJoinPoint point) {
        return this.messageList(this.argumentPojo(point, 0), point);
    }

    protected CMessage messageKey(Object id, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageKey message = new CMessageKey(id, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    protected List<CMessage> messagesCond(ProceedingJoinPoint point) {
        Object idSet = this.argumentCond(point);
        return this.messages(idSet, point);
    }

    protected List<CMessage> messagesPojo(ProceedingJoinPoint point, int index) {
        Object idSet = this.argumentCond(point, 0);
        return this.messages(idSet, point);
    }

    protected List<CMessage> messagesT(ProceedingJoinPoint point) {
        Object idSet = this.argumentT(point);
        return this.messages(idSet, point);
    }

    protected List<CMessage> messages(Object args, ProceedingJoinPoint point) {
        ArrayList<CMessage> messageList = new ArrayList<CMessage>();
        if (Objects.nonNull(args)) {
            if (args instanceof Collection) {
                ((Collection)args).forEach(id -> messageList.add(this.messageTree(id, point)));
            } else {
                Class<?> type = args.getClass();
                if (type.isArray()) {
                    Arrays.asList((Object[])args).forEach(id -> messageList.add(this.messageTree(id, point)));
                } else {
                    messageList.add(this.messageTree(args, point));
                }
            }
        }
        return messageList;
    }

    private CMessage messageUnique(JsonObject condition, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageUnique message = new CMessageUnique(condition, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    private CMessage messageUnique(String field, Object value, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageUnique message = new CMessageUnique(field, value, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    private CMessage messageList(JsonObject condition, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageList message = new CMessageList(condition, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    private CMessage messageList(String field, Object value, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageList message = new CMessageList(field, value, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    private CMessage messageTree(Object id, ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        CMessageTree message = new CMessageTree(id, analyzer.type());
        message.bind(analyzer.primarySet());
        return message;
    }

    private JsonObject argumentPojo(ProceedingJoinPoint point, int start) {
        JsonObject condition = (JsonObject)this.argument(point, start);
        Object[] args = point.getArgs();
        String pojo = (String)this.argument(point, args.length - 1);
        return JqTool.criteria(condition, pojo);
    }

    private <T> T argument(ProceedingJoinPoint point, Integer index) {
        Object[] args = point.getArgs();
        if (index < args.length) {
            return (T)args[index];
        }
        return null;
    }

    private Object argumentT(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        if (1 == args.length) {
            Object input = args[0];
            if (Objects.isNull(input)) {
                return null;
            }
            JqAnalyzer analyzer = this.analyzer(point);
            if (input instanceof Collection) {
                ArrayList idSet = new ArrayList();
                ((Collection)input).stream().map(analyzer::primaryValue).forEach(idSet::add);
                return idSet;
            }
            if (input instanceof String) {
                return input;
            }
            return analyzer.primaryValue(input);
        }
        return null;
    }

    private Object argumentCond(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        if (0 < args.length) {
            Object input = args[0];
            if (input instanceof JsonObject) {
                JsonObject condition = (JsonObject)input;
                return this.actionQr(point).searchPrimary(condition);
            }
            return null;
        }
        return null;
    }

    private Object argumentCond(ProceedingJoinPoint point, int index) {
        Object[] args = point.getArgs();
        if (index < args.length) {
            Object input = args[index];
            if (input instanceof JsonObject) {
                JsonObject condition = (JsonObject)input;
                String pojo = (String)args[args.length - 1];
                JsonObject criteria = JqTool.criteria(condition, pojo);
                return this.actionQr(point).searchPrimary(criteria);
            }
            return null;
        }
        return null;
    }

    protected L1Aside executor(ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        return new L1Aside(analyzer);
    }

    private ActionQr actionQr(ProceedingJoinPoint point) {
        JqAnalyzer analyzer = this.analyzer(point);
        return new ActionQr(analyzer);
    }

    private JqAnalyzer analyzer(ProceedingJoinPoint point) {
        return ((UxJooq)point.getTarget()).analyzer();
    }
}

