/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.cache;

import io.vertx.core.Future;
import io.vertx.tp.plugin.cache.Harp;
import io.vertx.tp.plugin.cache.hit.CMessage;
import io.vertx.tp.plugin.cache.l1.L1Cache;
import io.vertx.tp.plugin.cache.util.CacheAside;
import io.vertx.up.fn.Fn;
import io.vertx.up.fn.RunSupplier;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class L1Aside {
    protected final transient JqAnalyzer analyzer;
    protected final transient L1Cache cacheL1;

    public L1Aside(JqAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.cacheL1 = Harp.cacheL1();
    }

    private void writeCache(CMessage message) {
        if (Objects.nonNull(this.cacheL1)) {
            this.cacheL1.write(new CMessage[]{message});
        }
    }

    void deleteCache(List<CMessage> message) {
        if (Objects.nonNull(this.cacheL1)) {
            this.cacheL1.delete(message.toArray(new CMessage[0]));
        }
    }

    private <T> T wrapRead(CMessage message) {
        if (Objects.isNull(this.cacheL1)) {
            return null;
        }
        return (T)this.cacheL1.read(message);
    }

    private <T> Future<T> wrapReadAsync(CMessage message) {
        if (Objects.isNull(this.cacheL1)) {
            return Future.succeededFuture();
        }
        return this.cacheL1.readAsync(message);
    }

    private Boolean wrapExist(CMessage message) {
        if (Objects.isNull(this.cacheL1)) {
            return Boolean.FALSE;
        }
        return this.cacheL1.exist(message);
    }

    private Future<Boolean> wrapExistAsync(CMessage message) {
        if (Objects.isNull(this.cacheL1)) {
            return Future.succeededFuture((Object)Boolean.FALSE);
        }
        return this.cacheL1.existAsync(message);
    }

    <T> T delete(List<CMessage> messages, RunSupplier<T> actualSupplier) {
        Supplier<Object> wrapActual = () -> Fn.wrap((RunSupplier)actualSupplier, null);
        return (T)CacheAside.after(wrapActual, ret -> this.deleteCache(messages));
    }

    <T> Future<T> deleteAsync(List<CMessage> messages, RunSupplier<Future<T>> actualSupplier) {
        Supplier<Future> wrapActual = () -> Fn.wrapAsync((RunSupplier)actualSupplier, null);
        return CacheAside.afterAsync(wrapActual, ret -> this.deleteCache(messages));
    }

    <T> T read(CMessage message, RunSupplier<T> actualSupplier) {
        Supplier<Object> wrapActual = () -> Fn.wrap((RunSupplier)actualSupplier, null);
        Supplier<Object> wrapCache = () -> this.wrapRead(message);
        return (T)CacheAside.before(wrapCache, wrapActual, entity -> this.writeCache(message.data(entity)));
    }

    <T> Future<T> readAsync(CMessage message, RunSupplier<Future<T>> actualSupplier) {
        Supplier<Future> wrapActual = () -> Fn.wrapAsync((RunSupplier)actualSupplier, null);
        Supplier<Future> wrapCache = () -> this.wrapReadAsync(message);
        return CacheAside.beforeAsync(wrapCache, wrapActual, entity -> this.writeCache(message.data(entity)));
    }

    Boolean exist(CMessage message, RunSupplier<Boolean> actualSupplier) {
        Supplier<Boolean> wrapActual = () -> (Boolean)Fn.wrap((RunSupplier)actualSupplier, (Object)Boolean.FALSE);
        Supplier<Boolean> wrapCache = () -> this.wrapExist(message);
        return (Boolean)CacheAside.check(wrapCache, wrapActual);
    }

    Future<Boolean> existAsync(CMessage message, RunSupplier<Future<Boolean>> actualSupplier) {
        Supplier<Future> wrapActual = () -> Fn.wrapAsync((RunSupplier)actualSupplier, (Object)Boolean.FALSE);
        Supplier<Future> wrapCache = () -> this.wrapExistAsync(message);
        return CacheAside.checkAsync(wrapCache, wrapActual);
    }
}

