/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.matcher;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPath {
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");

    public static Pattern createRegex(String path) {
        if ((path = RE_OPERATORS_NO_STAR.matcher(path).replaceAll("\\\\$1")).charAt(path.length() - 1) == '*') {
            path = path.substring(0, path.length() - 1) + ".*";
        }
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(path);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> groups = new ArrayList<String>();
        int index = 0;
        while (m.find()) {
            String param = "p" + index;
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            groups.add(group);
            ++index;
        }
        m.appendTail(sb);
        path = sb.toString();
        return Pattern.compile(path);
    }
}

