/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.dispatch;

import io.vertx.core.eventbus.Message;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.annotations.Address;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.uca.rs.Aim;
import io.vertx.up.uca.rs.dispatch.Differ;
import io.vertx.up.uca.rs.dispatch.Pool;
import io.vertx.up.uca.rs.hunt.AsyncAim;
import io.vertx.up.uca.rs.hunt.OneWayAim;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.ReturnTypeException;
import io.vertx.zero.exception.WorkerMissingException;
import java.lang.reflect.Method;
import java.util.Set;

class EventDiffer
implements Differ<RoutingContext> {
    private static final Annal LOGGER = Annal.get(EventDiffer.class);
    private static final Set<Receipt> RECEIPTS = ZeroAnno.getReceipts();
    private static Differ<RoutingContext> INSTANCE = null;

    private EventDiffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Differ<RoutingContext> create() {
        if (null != INSTANCE) return INSTANCE;
        Class<EventDiffer> clazz = EventDiffer.class;
        synchronized (EventDiffer.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new EventDiffer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public Aim<RoutingContext> build(Event event) {
        Aim aim = null;
        Method replier = this.findReplier(event);
        Method method = event.getAction();
        Class<?> returnType = method.getReturnType();
        if (Void.class == returnType || Void.TYPE == returnType) {
            Fn.outUp((boolean)true, (Annal)LOGGER, ReturnTypeException.class, (Object[])new Object[]{this.getClass(), method});
        } else {
            Class<?> replierType = replier.getReturnType();
            aim = Void.class == replierType || Void.TYPE == replierType ? (this.isAsync(replier) ? (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "-mode-vert.x"), AsyncAim::new) : (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "-mode-oneway"), OneWayAim::new)) : (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "-mode-java"), AsyncAim::new);
        }
        return aim;
    }

    private boolean isAsync(Method method) {
        Class<?> argumentCls;
        boolean async = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (1 == paramTypes.length && Message.class == (argumentCls = paramTypes[0])) {
            async = true;
        }
        return async;
    }

    private Method findReplier(Event event) {
        Address annotation = event.getAction().getDeclaredAnnotation(Address.class);
        String address = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        Receipt found = RECEIPTS.stream().filter(item -> address.equals(item.getAddress())).findFirst().orElse(null);
        Fn.outUp((null == found ? 1 : 0) != 0, (Annal)LOGGER, WorkerMissingException.class, (Object[])new Object[]{this.getClass(), address});
        Method method = found.getMethod();
        Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, WorkerMissingException.class, (Object[])new Object[]{this.getClass(), address});
        return method;
    }
}

