/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.hunt;

import io.vertx.core.AsyncResult;
import io.vertx.core.eventbus.Message;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.annotations.Address;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._500DeliveryErrorException;
import io.vertx.up.exception.web._500EntityCastException;
import io.vertx.up.fn.Actuator;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.rs.hunt.Flower;
import io.vertx.up.uca.rs.mime.Analyzer;
import io.vertx.up.uca.rs.mime.MediaAnalyzer;
import io.vertx.up.uca.rs.validation.Validator;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BaseAim {
    private final transient Validator verifier = Validator.create();
    private final transient Analyzer analyzer = (Analyzer)Ut.singleton(MediaAnalyzer.class, (Object[])new Object[0]);

    protected Object[] buildArgs(RoutingContext context, Event event) {
        Object[] cached = (Object[])context.get("$$PARAM_CONTENT$$");
        if (null == cached) {
            cached = (Object[])this.analyzer.in(context, event);
            context.put("$$PARAM_CONTENT$$", (Object)cached);
        }
        return cached;
    }

    protected String address(Event event) {
        Method method = event.getAction();
        Address annotation = method.getDeclaredAnnotation(Address.class);
        return (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
    }

    protected Object invoke(Event event, Object[] args) {
        Method method = event.getAction();
        this.getLogger().info("Class = {2}, Method = {0}, Args = {1}", new Object[]{method.getName(), Ut.fromJoin((Object[])args), method.getDeclaringClass().getName()});
        return Ut.invoke((Object)event.getProxy(), (String)method.getName(), (Object[])args);
    }

    protected Envelop failure(String address, AsyncResult<Message<Envelop>> handler) {
        _500DeliveryErrorException error = new _500DeliveryErrorException(this.getClass(), address, (String)Fn.getNull(null, () -> handler.cause().getMessage(), (Object[])new Object[]{handler.cause()}));
        return Envelop.failure(error);
    }

    protected Envelop success(String address, AsyncResult<Message<Envelop>> handler) {
        Envelop envelop;
        try {
            Message message = (Message)handler.result();
            envelop = (Envelop)message.body();
        }
        catch (Throwable ex) {
            _500EntityCastException error = new _500EntityCastException(this.getClass(), address, ex.getMessage());
            envelop = Envelop.failure(error);
        }
        return envelop;
    }

    protected Validator verifier() {
        return this.verifier;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected void executeRequest(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot) {
        try {
            Object[] args = this.buildArgs(context, depot.getEvent());
            Flower.executeRequest(context, rulers, depot, args, this.verifier());
        }
        catch (WebException error) {
            Flower.replyError(context, error, depot.getEvent());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void exec(Actuator consumer, RoutingContext context, Event event) {
        try {
            Session session = context.session();
            if (Objects.nonNull(session)) {
                Cookie cookie = context.getCookie("vertx-web.session");
                this.getLogger().info("( Session ) \n\t\tPath = {0}, Session Id = {1}, Client Cookie Value {2}", new Object[]{context.request().path(), session.id(), Objects.isNull(cookie) ? null : cookie.getValue()});
            }
            consumer.execute();
        }
        catch (WebException ex) {
            Flower.replyError(context, ex, event);
        }
    }
}

