/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.mime;

import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.rs.mime.Analyzer;
import io.vertx.up.uca.rs.mime.MediaAtom;
import io.vertx.up.uca.rs.mime.parse.EpsilonIncome;
import io.vertx.up.uca.rs.mime.parse.Income;
import io.vertx.up.util.Ut;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class MediaAnalyzer
implements Analyzer {
    private static final Annal LOGGER = Annal.get(MediaAnalyzer.class);
    private final transient Income<List<Epsilon<Object>>> income = (Income)Ut.singleton(EpsilonIncome.class, (Object[])new Object[0]);

    @Override
    public Object[] in(RoutingContext context, Event event) throws WebException {
        MediaType requestMedia = this.getMedia(context);
        MediaAtom.accept(event, requestMedia);
        List<Epsilon<Object>> epsilons = this.income.in(context, event);
        return epsilons.stream().map(Epsilon::getValue).toArray();
    }

    @Override
    public Envelop out(Envelop envelop, Event event) throws WebException {
        return null;
    }

    private MediaType getMedia(RoutingContext context) {
        String header = context.request().getHeader("Content-Type");
        return (MediaType)Fn.getSemi((boolean)Ut.isNil((String)header), (Annal)LOGGER, () -> MediaType.WILDCARD_TYPE, () -> MediaType.valueOf((String)header));
    }
}

