/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.mime.resolver;

import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroSerializer;
import io.vertx.up.uca.rs.mime.Resolver;
import io.vertx.up.util.Ut;

public class JsonResolver<T>
implements Resolver<T> {
    private static final Annal LOGGER = Annal.get(JsonResolver.class);

    @Override
    public Epsilon<T> resolve(RoutingContext context, Epsilon<T> income) {
        String content = context.getBodyAsString();
        LOGGER.info("( Resolver ) Income Type: {0}, Content = {1}", new Object[]{income.getArgType().getName(), content});
        if (Ut.isNil((String)content)) {
            Object defaultValue = income.getDefaultValue();
            income.setValue(defaultValue);
        } else {
            Object result = ZeroSerializer.getValue(income.getArgType(), content);
            if (null != result) {
                income.setValue(result);
            }
        }
        return income;
    }
}

